/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.retryer;

import com.dtflys.forest.exceptions.ForestRetryException;
import com.dtflys.forest.http.ForestRequest;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ForestRetryer {
    protected final ForestRequest request;
    private AtomicInteger currentRetryCount = new AtomicInteger(0);

    protected ForestRetryer(ForestRequest request) {
        this.request = request;
    }

    public ForestRequest getRequest() {
        return this.request;
    }

    public int getMaxRetryCount() {
        return this.request.getRetryCount();
    }

    public long getMaxRetryInterval() {
        return this.request.getMaxRetryInterval();
    }

    public int getCurrentRetryCount() {
        return this.currentRetryCount.get();
    }

    public int getAndIncrementCurrentRetryCount() {
        return this.currentRetryCount.getAndIncrement();
    }

    public abstract void canRetry(ForestRetryException var1) throws Throwable;
}

