/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.ssl;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.ssl.SSLKeyStore;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ForestX509TrustManager
implements X509TrustManager {
    private X509TrustManager sunJSSEX509TrustManager;
    private final SSLKeyStore sslKeyStore;

    public ForestX509TrustManager(SSLKeyStore sslKeyStore) throws Exception {
        this.sslKeyStore = sslKeyStore;
        KeyStore ks = sslKeyStore.getTrustStore();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
        tmf.init(ks);
        TrustManager[] tms = tmf.getTrustManagers();
        for (int i = 0; i < tms.length; ++i) {
            if (!(tms[i] instanceof X509TrustManager)) continue;
            this.sunJSSEX509TrustManager = (X509TrustManager)tms[i];
            return;
        }
        throw new ForestRuntimeException("Couldn't initialize X509TrustManager");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.sunJSSEX509TrustManager.checkClientTrusted(chain, authType);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.sunJSSEX509TrustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.sunJSSEX509TrustManager.getAcceptedIssuers();
    }
}

