/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.ssl;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.ssl.SSLSocketFactoryBuilder;
import com.dtflys.forest.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.TrustManager;

public class SSLKeyStore {
    public static final String DEFAULT_KEYSTORE_TYPE = "jks";
    protected final String id;
    protected final String keystoreType;
    protected String filePath;
    protected InputStream inputStream;
    protected String keystorePass;
    protected String certPass;
    protected KeyStore trustStore;
    protected String[] protocols;
    protected String[] cipherSuites;
    protected TrustManager trustManager;
    protected HostnameVerifier hostnameVerifier;
    protected SSLSocketFactoryBuilder sslSocketFactoryBuilder;

    public SSLKeyStore(String id, String filePath, String keystorePass, String certPass, TrustManager trustManager, HostnameVerifier hostnameVerifier, SSLSocketFactoryBuilder sslSocketFactoryBuilder) {
        this(id, DEFAULT_KEYSTORE_TYPE, filePath, keystorePass, certPass, trustManager, hostnameVerifier, sslSocketFactoryBuilder);
    }

    public SSLKeyStore(String id, String keystoreType, String filePath, String keystorePass, String certPass, TrustManager trustManager, HostnameVerifier hostnameVerifier, SSLSocketFactoryBuilder sslSocketFactoryBuilder) {
        this.id = id;
        this.keystoreType = keystoreType;
        this.filePath = filePath;
        this.keystorePass = keystorePass;
        this.certPass = certPass;
        this.trustManager = trustManager;
        this.hostnameVerifier = hostnameVerifier;
        this.sslSocketFactoryBuilder = sslSocketFactoryBuilder;
        this.init();
        this.loadTrustStore();
    }

    public String getId() {
        return this.id;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public void setProtocols(String[] protocols) {
        this.protocols = protocols;
    }

    public String[] getCipherSuites() {
        return this.cipherSuites;
    }

    public void setCipherSuites(String[] cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public TrustManager getTrustManager() {
        return this.trustManager;
    }

    public void setTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public SSLSocketFactoryBuilder getSslSocketFactoryBuilder() {
        return this.sslSocketFactoryBuilder;
    }

    public void setSslSocketFactoryBuilder(SSLSocketFactoryBuilder sslSocketFactoryBuilder) {
        this.sslSocketFactoryBuilder = sslSocketFactoryBuilder;
    }

    public void init() {
        if (StringUtils.isNotBlank(this.filePath)) {
            String path = this.filePath.trim();
            File file = new File(path);
            if (!file.exists()) {
                URL url = this.getClass().getClassLoader().getResource(path);
                if (url == null) {
                    throw new ForestRuntimeException("The file of SSL KeyStore \"" + this.id + "\" " + this.filePath + " cannot be found!");
                }
                path = url.getFile();
                file = new File(path);
                if (!file.exists()) {
                    throw new ForestRuntimeException("The file of SSL KeyStore \"" + this.id + "\" " + this.filePath + " cannot be found!");
                }
            }
            try {
                this.inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new ForestRuntimeException("An error occurred while reading he file of SSL KeyStore \"\" + id + \"\"", e);
            }
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public String getCertPass() {
        return this.certPass;
    }

    public void setKeystorePass(String keystorePass) {
        this.keystorePass = keystorePass;
    }

    public void loadTrustStore() {
        if (this.inputStream != null) {
            try {
                this.trustStore = KeyStore.getInstance(this.keystoreType);
                String pass = this.keystorePass;
                if (pass == null) {
                    this.trustStore.load(this.inputStream, null);
                } else {
                    this.trustStore.load(this.inputStream, pass.trim().toCharArray());
                }
            }
            catch (KeyStoreException e) {
                throw new ForestRuntimeException(e);
            }
            catch (CertificateException e) {
                throw new ForestRuntimeException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ForestRuntimeException(e);
            }
            catch (IOException e) {
                throw new ForestRuntimeException(e);
            }
            finally {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }
}

