/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.utils;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ForestDataType {
    public static final Map<String, ForestDataType> DATA_TYPES = new HashMap<String, ForestDataType>();
    public static final ForestDataType AUTO = ForestDataType.createDataType("auto", null);
    public static final ForestDataType TEXT = ForestDataType.createDataType("text", false);
    public static final ForestDataType FORM = ForestDataType.createDataType("form", true);
    public static final ForestDataType JSON = ForestDataType.createDataType("json", true);
    public static final ForestDataType XML = ForestDataType.createDataType("xml", false);
    public static final ForestDataType BINARY = ForestDataType.createDataType("binary", false);
    public static final ForestDataType MULTIPART = ForestDataType.createDataType("multipart", true);
    public static final ForestDataType PROTOBUF = ForestDataType.createDataType("protobuf", true);
    private final String name;
    private final Boolean hasNameValue;

    public static ForestDataType createDataType(String name, Boolean hasNameValue) {
        if (StringUtils.isEmpty(name)) {
            throw new ForestRuntimeException("Data type name cannot be empty!");
        }
        name = name.toLowerCase();
        ForestDataType dataType = new ForestDataType(name, hasNameValue);
        if (DATA_TYPES.containsKey(name)) {
            throw new ForestRuntimeException("Data type '" + name + "' has already been existed!");
        }
        DATA_TYPES.put(name, dataType);
        return dataType;
    }

    private ForestDataType(String name, Boolean hasNameValue) {
        this.name = name;
        this.hasNameValue = hasNameValue;
    }

    public String getName() {
        return this.name;
    }

    public static ForestDataType findByName(String name) {
        return DATA_TYPES.get(name.toLowerCase());
    }

    public static ForestDataType findOrCreateDataType(String name) {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        ForestDataType dataType = DATA_TYPES.get(name = name.toLowerCase());
        if (dataType == null) {
            dataType = ForestDataType.createDataType(name, null);
        }
        return dataType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ForestDataType)) {
            return false;
        }
        ForestDataType that = (ForestDataType)o;
        return Objects.equals(this.getName(), that.getName());
    }

    public Boolean hasNameValue() {
        return this.hasNameValue;
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }
}

