/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;

public class GzipUtils {
    public static boolean isGzip(String contentEncoding) {
        String[] encodes;
        if (contentEncoding != null && (encodes = contentEncoding.split(",")).length > 0) {
            for (String encode : encodes) {
                if (!"gzip".equalsIgnoreCase(encode.trim())) continue;
                return true;
            }
        }
        return false;
    }

    public static GZIPInputStream decompressGzipInputStream(InputStream in) throws IOException {
        GZIPInputStream gzipInputStream = new GZIPInputStream(in);
        return gzipInputStream;
    }

    public static byte[] decompressGzipToByteArray(GZIPInputStream gzipIn) throws IOException {
        return IOUtils.toByteArray((InputStream)gzipIn);
    }

    public static String decompressGzipToString(GZIPInputStream gzipIn, String encoding) throws IOException {
        return IOUtils.toString((InputStream)gzipIn, (String)encoding);
    }

    public static byte[] decompressGzipToByteArray(InputStream in) throws IOException {
        return IOUtils.toByteArray((InputStream)GzipUtils.decompressGzipInputStream(in));
    }

    public static String decompressGzipToString(InputStream in, String encoding) throws IOException {
        return IOUtils.toString((InputStream)GzipUtils.decompressGzipInputStream(in), (String)encoding);
    }

    public static String decompressGzipToString(byte[] bytes, String encoding) throws IOException {
        return IOUtils.toString((InputStream)GzipUtils.decompressGzipInputStream(new ByteArrayInputStream(bytes)), (String)encoding);
    }
}

