/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.utils;

import com.dtflys.forest.annotation.AliasFor;
import com.dtflys.forest.annotation.BaseLifeCycle;
import com.dtflys.forest.annotation.MethodLifeCycle;
import com.dtflys.forest.annotation.ParamLifeCycle;
import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.converter.json.JSONConverterSelector;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.utils.NameUtils;
import com.dtflys.forest.utils.StringUtils;
import com.dtflys.forest.utils.TypeReference;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectUtils {
    private static ForestJsonConverter FORM_MAP_CONVERTER;
    private static JSONConverterSelector jsonConverterSelector;
    private static Set<String> excludedAnntotationMethodNames;

    public static Type toType(Type type) {
        if (type instanceof TypeReference) {
            return ((TypeReference)type).getType();
        }
        return type;
    }

    public static Class<?> toClass(Type genericType) {
        if (genericType instanceof TypeReference) {
            return ReflectUtils.toClass(((TypeReference)genericType).getType());
        }
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            return (Class)pt.getRawType();
        }
        if (genericType instanceof TypeVariable) {
            TypeVariable tType = (TypeVariable)genericType;
            String className = tType.getGenericDeclaration().toString();
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        if (genericType instanceof WildcardType && "?".equals(genericType.toString())) {
            return Object.class;
        }
        try {
            return (Class)genericType;
        }
        catch (Throwable th) {
            return Object.class;
        }
    }

    public static ParameterizedType toParameterizedType(Type type) {
        if (null == type) {
            return null;
        }
        ParameterizedType pType = null;
        if (type instanceof ParameterizedType) {
            pType = (ParameterizedType)type;
        } else if (type instanceof Class) {
            Type[] genericInterfaces;
            Class clazz = (Class)type;
            Type genericSuper = clazz.getGenericSuperclass();
            if ((genericSuper == null || Object.class.equals((Object)genericSuper)) && (genericInterfaces = clazz.getGenericInterfaces()).length > 0) {
                genericSuper = genericInterfaces[0];
            }
            pType = ReflectUtils.toParameterizedType(genericSuper);
        }
        return pType;
    }

    public static Type[] getGenericTypeArguments(Type type) {
        ParameterizedType pType = ReflectUtils.toParameterizedType(type);
        if (pType != null) {
            return pType.getActualTypeArguments();
        }
        return null;
    }

    public static Type getGenericArgument(Type type, int index) {
        Type[] arguments = ReflectUtils.getGenericTypeArguments(type);
        if (arguments != null && arguments.length > index) {
            return arguments[index];
        }
        return null;
    }

    public static Type getGenericArgument(Type type) {
        return ReflectUtils.getGenericArgument(type, 0);
    }

    public static boolean isPrimaryType(Class<?> type) {
        if (Byte.TYPE.isAssignableFrom(type) || Byte.class.isAssignableFrom(type)) {
            return true;
        }
        if (Boolean.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type)) {
            return true;
        }
        if (Integer.TYPE.isAssignableFrom(type) || Integer.class.isAssignableFrom(type)) {
            return true;
        }
        if (Long.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type)) {
            return true;
        }
        if (Short.TYPE.isAssignableFrom(type) || Short.class.isAssignableFrom(type)) {
            return true;
        }
        if (Float.TYPE.isAssignableFrom(type) || Float.class.isAssignableFrom(type)) {
            return true;
        }
        if (Double.TYPE.isAssignableFrom(type) || Double.class.isAssignableFrom(type)) {
            return true;
        }
        if (Character.TYPE.isAssignableFrom(type) || Character.class.isAssignableFrom(type)) {
            return true;
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return true;
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return true;
        }
        return CharSequence.class.isAssignableFrom(type);
    }

    public static boolean isPrimaryArrayType(Class type) {
        if (!type.isArray()) {
            return false;
        }
        if (byte[].class.isAssignableFrom(type) || Byte[].class.isAssignableFrom(type)) {
            return true;
        }
        if (boolean[].class.isAssignableFrom(type) || Boolean[].class.isAssignableFrom(type)) {
            return true;
        }
        if (int[].class.isAssignableFrom(type) || Integer[].class.isAssignableFrom(type)) {
            return true;
        }
        if (long[].class.isAssignableFrom(type) || Long[].class.isAssignableFrom(type)) {
            return true;
        }
        if (short[].class.isAssignableFrom(type) || Short[].class.isAssignableFrom(type)) {
            return true;
        }
        if (float[].class.isAssignableFrom(type) || Float[].class.isAssignableFrom(type)) {
            return true;
        }
        if (double[].class.isAssignableFrom(type) || Double[].class.isAssignableFrom(type)) {
            return true;
        }
        if (BigDecimal[].class.isAssignableFrom(type)) {
            return true;
        }
        if (BigInteger[].class.isAssignableFrom(type)) {
            return true;
        }
        return CharSequence[].class.isAssignableFrom(type);
    }

    public static Map<String, Object> getAttributesFromAnnotation(Annotation ann) {
        ConcurrentHashMap<String, Object> results = new ConcurrentHashMap<String, Object>();
        Class<? extends Annotation> clazz = ann.annotationType();
        Method[] methods = clazz.getMethods();
        Object[] args = new Object[]{};
        for (Method method : methods) {
            AliasFor aliasFor;
            String name = method.getName();
            if (excludedAnntotationMethodNames.contains(name) || method.getParameters().length > 0) continue;
            Object value = ReflectUtils.invokeAnnotationMethod(ann, clazz, name, args);
            if ((value == null || value instanceof CharSequence && StringUtils.isEmpty(String.valueOf(value))) && (aliasFor = method.getAnnotation(AliasFor.class)) != null) {
                String aliasName = aliasFor.value();
                value = ReflectUtils.invokeAnnotationMethod(ann, clazz, aliasName, args);
            }
            results.put(name, value);
        }
        return results;
    }

    public static boolean isForestAnnotation(Annotation annotation) {
        return ReflectUtils.isForestParamAnnotation(annotation.annotationType());
    }

    public static boolean isForestAnnotation(Class annotationType) {
        return ReflectUtils.isForestBaseAnnotation(annotationType) || ReflectUtils.isForestMethodAnnotation(annotationType) || ReflectUtils.isForestParamAnnotation(annotationType);
    }

    public static boolean isForestBaseAnnotation(Annotation annotation) {
        return ReflectUtils.isForestBaseAnnotation(annotation);
    }

    public static boolean isForestBaseAnnotation(Class annotationType) {
        BaseLifeCycle mlcAnn = annotationType.getAnnotation(BaseLifeCycle.class);
        return mlcAnn != null;
    }

    public static boolean isForestMethodAnnotation(Annotation annotation) {
        return ReflectUtils.isForestMethodAnnotation(annotation.annotationType());
    }

    public static boolean isForestMethodAnnotation(Class annotationType) {
        MethodLifeCycle mlcAnn = annotationType.getAnnotation(MethodLifeCycle.class);
        return mlcAnn != null;
    }

    public static boolean isForestParamAnnotation(Annotation annotation) {
        return ReflectUtils.isForestParamAnnotation(annotation.annotationType());
    }

    public static boolean isForestParamAnnotation(Class annotationType) {
        ParamLifeCycle mlcAnn = annotationType.getAnnotation(ParamLifeCycle.class);
        return mlcAnn != null;
    }

    public static boolean canAnnotationUseForInterface(Class annotationType) {
        return ReflectUtils.isForestBaseAnnotation(annotationType);
    }

    public static boolean canAnnotationUseForMethod(Class annotationType) {
        return ReflectUtils.isForestMethodAnnotation(annotationType);
    }

    public static boolean canAnnotationUseForParam(Class annotationType) {
        return ReflectUtils.isForestParamAnnotation(annotationType);
    }

    private static Object invokeAnnotationMethod(Annotation ann, Class clazz, String name, Object[] args) {
        Method method = null;
        try {
            method = clazz.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ForestRuntimeException(e);
        }
        if (method != null) {
            try {
                return method.invoke((Object)ann, args);
            }
            catch (IllegalAccessException e) {
                throw new ForestRuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new ForestRuntimeException(e);
            }
        }
        return null;
    }

    public static void copyAnnotationAttributes(Annotation source, Object target) {
        if (target == null) {
            return;
        }
        Map<String, Object> attrs = ReflectUtils.getAttributesFromAnnotation(source);
        Class<?> targetClass = target.getClass();
        for (String name : attrs.keySet()) {
            String methodName = NameUtils.setterName(name);
            try {
                Method setterMethod = null;
                for (Method method : targetClass.getMethods()) {
                    if (!method.getName().equals(methodName) || method.getParameterTypes().length != 1) continue;
                    setterMethod = method;
                    break;
                }
                if (setterMethod == null) continue;
                setterMethod.invoke(target, attrs.get(name));
            }
            catch (Throwable e) {
                throw new ForestRuntimeException(e);
            }
        }
    }

    public static Map convertObjectToMap(Object srcObj, ForestConfiguration configuration) {
        if (configuration != null) {
            return configuration.getJsonConverter().convertObjectToMap(srcObj);
        }
        if (FORM_MAP_CONVERTER == null) {
            FORM_MAP_CONVERTER = jsonConverterSelector.select();
        }
        return FORM_MAP_CONVERTER.convertObjectToMap(srcObj);
    }

    static {
        jsonConverterSelector = new JSONConverterSelector();
        excludedAnntotationMethodNames = new HashSet<String>();
        excludedAnntotationMethodNames.add("equals");
        excludedAnntotationMethodNames.add("getClass");
        excludedAnntotationMethodNames.add("annotationType");
        excludedAnntotationMethodNames.add("notify");
        excludedAnntotationMethodNames.add("notifyAll");
        excludedAnntotationMethodNames.add("wait");
        excludedAnntotationMethodNames.add("hashCode");
        excludedAnntotationMethodNames.add("toString");
        excludedAnntotationMethodNames.add("newProxyInstance");
        excludedAnntotationMethodNames.add("newProxyClass");
        excludedAnntotationMethodNames.add("getInvocationHandler");
    }
}

