/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.utils;

import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import okio.ByteString;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean isEmpty(CharSequence text) {
        return text == null || text.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence text) {
        return !StringUtils.isEmpty(text);
    }

    public static boolean isBlank(String text) {
        if (text == null) {
            return true;
        }
        if (text.length() == 0) {
            return true;
        }
        char[] chars = text.toCharArray();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String text) {
        return !StringUtils.isBlank(text);
    }

    public static String getGetterName(Method mtd) {
        String name = mtd.getName();
        if (name.startsWith("get")) {
            return Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        if (name.startsWith("is")) {
            return Character.toLowerCase(name.charAt(2)) + name.substring(3);
        }
        return null;
    }

    public static String toGetterName(String name) {
        return "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public static String trimBegin(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int len = str.length();
        boolean before = true;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (before && (ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r')) continue;
            builder.append(ch);
            before = false;
        }
        return builder.toString();
    }

    public static String fromBytes(byte[] bytes, Charset charset, Charset defaultCharset) {
        if (charset == null) {
            charset = defaultCharset;
        }
        return new String(bytes, charset);
    }

    public static String fromBytes(byte[] bytes, Charset charset) {
        return StringUtils.fromBytes(bytes, charset, StandardCharsets.UTF_8);
    }

    public static String generateBoundary() {
        UUID uuid = UUID.randomUUID();
        return ByteString.encodeUtf8((String)uuid.toString()).utf8();
    }
}

