/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.utils;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class TimeUtils {
    public static boolean isNone(Integer duration) {
        if (duration == null) {
            return true;
        }
        return duration < 0;
    }

    public static boolean isNotNone(Integer duration) {
        return !TimeUtils.isNone(duration);
    }

    public static Integer toMillis(String name, Integer duration, TimeUnit timeUnit) {
        if (TimeUtils.isNone(duration)) {
            return null;
        }
        if (timeUnit != null) {
            long millis = timeUnit.toMillis(duration.intValue());
            if (millis > Integer.MAX_VALUE) {
                throw new ForestRuntimeException(name + " (" + millis + " ms) is too large");
            }
            return (int)millis;
        }
        return duration;
    }

    public static Integer toMillis(String name, Duration duration) {
        if (duration != null) {
            long millis = duration.toMillis();
            if (millis > Integer.MAX_VALUE) {
                throw new ForestRuntimeException(name + " (" + millis + " ms) is too large");
            }
            return (int)millis;
        }
        return null;
    }
}

