/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdRuleEvaluationSpec;
import com.facebook.ads.sdk.AdRuleExecutionSpec;
import com.facebook.ads.sdk.AdRuleHistoryResult;
import com.facebook.ads.sdk.AdRuleScheduleSpec;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class AdRuleHistory
extends APINode {
    @SerializedName(value="evaluation_spec")
    private AdRuleEvaluationSpec mEvaluationSpec = null;
    @SerializedName(value="exception_code")
    private Long mExceptionCode = null;
    @SerializedName(value="exception_message")
    private String mExceptionMessage = null;
    @SerializedName(value="execution_spec")
    private AdRuleExecutionSpec mExecutionSpec = null;
    @SerializedName(value="is_manual")
    private Boolean mIsManual = null;
    @SerializedName(value="results")
    private List<AdRuleHistoryResult> mResults = null;
    @SerializedName(value="schedule_spec")
    private AdRuleScheduleSpec mScheduleSpec = null;
    @SerializedName(value="timestamp")
    private String mTimestamp = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdRuleHistory loadJSON(String json, APIContext context, String header) {
        AdRuleHistory adRuleHistory = (AdRuleHistory)AdRuleHistory.getGson().fromJson(json, AdRuleHistory.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adRuleHistory.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adRuleHistory.context = context;
        adRuleHistory.rawValue = json;
        adRuleHistory.header = header;
        return adRuleHistory;
    }

    public static APINodeList<AdRuleHistory> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdRuleHistory> adRuleHistorys = new APINodeList<AdRuleHistory>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adRuleHistorys.add(AdRuleHistory.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adRuleHistorys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adRuleHistorys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adRuleHistorys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adRuleHistorys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adRuleHistorys.add(AdRuleHistory.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adRuleHistorys.add(AdRuleHistory.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adRuleHistorys.add(AdRuleHistory.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adRuleHistorys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adRuleHistorys.add(AdRuleHistory.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adRuleHistorys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adRuleHistorys.add(AdRuleHistory.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adRuleHistorys;
                }
                adRuleHistorys.clear();
                adRuleHistorys.add(AdRuleHistory.loadJSON(json, context, header));
                return adRuleHistorys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdRuleHistory.getGson().toJson((Object)this);
    }

    public AdRuleEvaluationSpec getFieldEvaluationSpec() {
        if (this.mEvaluationSpec != null) {
            this.mEvaluationSpec.context = this.getContext();
        }
        return this.mEvaluationSpec;
    }

    public AdRuleHistory setFieldEvaluationSpec(AdRuleEvaluationSpec value) {
        this.mEvaluationSpec = value;
        return this;
    }

    public AdRuleHistory setFieldEvaluationSpec(String value) {
        Type type = new TypeToken<AdRuleEvaluationSpec>(){}.getType();
        this.mEvaluationSpec = (AdRuleEvaluationSpec)AdRuleEvaluationSpec.getGson().fromJson(value, type);
        return this;
    }

    public Long getFieldExceptionCode() {
        return this.mExceptionCode;
    }

    public AdRuleHistory setFieldExceptionCode(Long value) {
        this.mExceptionCode = value;
        return this;
    }

    public String getFieldExceptionMessage() {
        return this.mExceptionMessage;
    }

    public AdRuleHistory setFieldExceptionMessage(String value) {
        this.mExceptionMessage = value;
        return this;
    }

    public AdRuleExecutionSpec getFieldExecutionSpec() {
        if (this.mExecutionSpec != null) {
            this.mExecutionSpec.context = this.getContext();
        }
        return this.mExecutionSpec;
    }

    public AdRuleHistory setFieldExecutionSpec(AdRuleExecutionSpec value) {
        this.mExecutionSpec = value;
        return this;
    }

    public AdRuleHistory setFieldExecutionSpec(String value) {
        Type type = new TypeToken<AdRuleExecutionSpec>(){}.getType();
        this.mExecutionSpec = (AdRuleExecutionSpec)AdRuleExecutionSpec.getGson().fromJson(value, type);
        return this;
    }

    public Boolean getFieldIsManual() {
        return this.mIsManual;
    }

    public AdRuleHistory setFieldIsManual(Boolean value) {
        this.mIsManual = value;
        return this;
    }

    public List<AdRuleHistoryResult> getFieldResults() {
        return this.mResults;
    }

    public AdRuleHistory setFieldResults(List<AdRuleHistoryResult> value) {
        this.mResults = value;
        return this;
    }

    public AdRuleHistory setFieldResults(String value) {
        Type type = new TypeToken<List<AdRuleHistoryResult>>(){}.getType();
        this.mResults = (List)AdRuleHistoryResult.getGson().fromJson(value, type);
        return this;
    }

    public AdRuleScheduleSpec getFieldScheduleSpec() {
        return this.mScheduleSpec;
    }

    public AdRuleHistory setFieldScheduleSpec(AdRuleScheduleSpec value) {
        this.mScheduleSpec = value;
        return this;
    }

    public AdRuleHistory setFieldScheduleSpec(String value) {
        Type type = new TypeToken<AdRuleScheduleSpec>(){}.getType();
        this.mScheduleSpec = (AdRuleScheduleSpec)AdRuleScheduleSpec.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldTimestamp() {
        return this.mTimestamp;
    }

    public AdRuleHistory setFieldTimestamp(String value) {
        this.mTimestamp = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdRuleHistory copyFrom(AdRuleHistory instance) {
        this.mEvaluationSpec = instance.mEvaluationSpec;
        this.mExceptionCode = instance.mExceptionCode;
        this.mExceptionMessage = instance.mExceptionMessage;
        this.mExecutionSpec = instance.mExecutionSpec;
        this.mIsManual = instance.mIsManual;
        this.mResults = instance.mResults;
        this.mScheduleSpec = instance.mScheduleSpec;
        this.mTimestamp = instance.mTimestamp;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdRuleHistory> getParser() {
        return new APIRequest.ResponseParser<AdRuleHistory>(){

            @Override
            public APINodeList<AdRuleHistory> parseResponse(String response, APIContext context, APIRequest<AdRuleHistory> request, String header) throws APIException.MalformedResponseException {
                return AdRuleHistory.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumAction {
        VALUE_BUDGET_NOT_REDISTRIBUTED("BUDGET_NOT_REDISTRIBUTED"),
        VALUE_CHANGED_BID("CHANGED_BID"),
        VALUE_CHANGED_BUDGET("CHANGED_BUDGET"),
        VALUE_EMAIL("EMAIL"),
        VALUE_ENDPOINT_PINGED("ENDPOINT_PINGED"),
        VALUE_ERROR("ERROR"),
        VALUE_FACEBOOK_NOTIFICATION_SENT("FACEBOOK_NOTIFICATION_SENT"),
        VALUE_MESSAGE_SENT("MESSAGE_SENT"),
        VALUE_NOT_CHANGED("NOT_CHANGED"),
        VALUE_PAUSED("PAUSED"),
        VALUE_UNPAUSED("UNPAUSED");

        private String value;

        private EnumAction(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

