/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.hibernate4;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import java.beans.Introspector;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.persistence.EntityNotFoundException;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.proxy.pojo.BasicLazyInitializer;

public class HibernateProxySerializer
extends JsonSerializer<HibernateProxy>
implements ContextualSerializer {
    protected final BeanProperty _property;
    protected final boolean _forceLazyLoading;
    protected final boolean _serializeIdentifier;
    protected final boolean _nullMissingEntities;
    protected final Mapping _mapping;
    protected PropertySerializerMap _dynamicSerializers;

    public HibernateProxySerializer(boolean forceLazyLoading) {
        this(forceLazyLoading, false, false, null, null);
    }

    public HibernateProxySerializer(boolean forceLazyLoading, boolean serializeIdentifier) {
        this(forceLazyLoading, serializeIdentifier, false, null, null);
    }

    public HibernateProxySerializer(boolean forceLazyLoading, boolean serializeIdentifier, Mapping mapping) {
        this(forceLazyLoading, serializeIdentifier, false, mapping, null);
    }

    public HibernateProxySerializer(boolean forceLazyLoading, boolean serializeIdentifier, boolean nullMissingEntities, Mapping mapping) {
        this(forceLazyLoading, serializeIdentifier, nullMissingEntities, mapping, null);
    }

    public HibernateProxySerializer(boolean forceLazyLoading, boolean serializeIdentifier, boolean nullMissingEntities, Mapping mapping, BeanProperty property) {
        this._forceLazyLoading = forceLazyLoading;
        this._serializeIdentifier = serializeIdentifier;
        this._nullMissingEntities = nullMissingEntities;
        this._mapping = mapping;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
        this._property = property;
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) {
        return new HibernateProxySerializer(this._forceLazyLoading, this._serializeIdentifier, this._nullMissingEntities, this._mapping, property);
    }

    public boolean isEmpty(SerializerProvider provider, HibernateProxy value) {
        return value == null || this.findProxied(value) == null;
    }

    public void serialize(HibernateProxy value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        Object proxiedValue = this.findProxied(value);
        if (proxiedValue == null) {
            provider.defaultSerializeNull(jgen);
            return;
        }
        this.findSerializer(provider, proxiedValue).serialize(proxiedValue, jgen, provider);
    }

    public void serializeWithType(HibernateProxy value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        Object proxiedValue = this.findProxied(value);
        if (proxiedValue == null) {
            provider.defaultSerializeNull(jgen);
            return;
        }
        this.findSerializer(provider, proxiedValue).serializeWithType(proxiedValue, jgen, provider, typeSer);
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        SerializerProvider prov = visitor.getProvider();
        if (prov == null || this._property == null) {
            super.acceptJsonFormatVisitor(visitor, typeHint);
        } else {
            JavaType type = this._property.getType();
            prov.findPrimaryPropertySerializer(type, this._property).acceptJsonFormatVisitor(visitor, type);
        }
    }

    protected JsonSerializer<Object> findSerializer(SerializerProvider provider, Object value) throws IOException {
        Class<?> type = value.getClass();
        PropertySerializerMap.SerializerAndMapResult result = this._dynamicSerializers.findAndAddPrimarySerializer(type, provider, this._property);
        if (this._dynamicSerializers != result.map) {
            this._dynamicSerializers = result.map;
        }
        return result.serializer;
    }

    protected Object findProxied(HibernateProxy proxy) {
        LazyInitializer init = proxy.getHibernateLazyInitializer();
        if (!this._forceLazyLoading && init.isUninitialized()) {
            if (this._serializeIdentifier) {
                String idName;
                if (this._mapping != null) {
                    idName = this._mapping.getIdentifierPropertyName(init.getEntityName());
                } else {
                    SessionImplementor session = init.getSession();
                    if (session != null) {
                        idName = session.getFactory().getIdentifierPropertyName(init.getEntityName());
                    } else {
                        idName = ProxyReader.getIdentifierPropertyName(init);
                        if (idName == null) {
                            idName = init.getEntityName();
                        }
                    }
                }
                Serializable idValue = init.getIdentifier();
                HashMap<String, Serializable> map = new HashMap<String, Serializable>();
                map.put(idName, idValue);
                return map;
            }
            return null;
        }
        try {
            return init.getImplementation();
        }
        catch (EntityNotFoundException e) {
            if (this._nullMissingEntities) {
                return null;
            }
            throw e;
        }
    }

    protected static class ProxyReader {
        private static final Field getIdentifierMethodField;

        protected ProxyReader() {
        }

        static String getIdentifierPropertyName(LazyInitializer init) {
            try {
                Method idGetter = (Method)getIdentifierMethodField.get(init);
                if (idGetter == null) {
                    return null;
                }
                String name = idGetter.getName();
                if (name.startsWith("get")) {
                    name = Introspector.decapitalize(name.substring(3));
                }
                return name;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        static {
            try {
                getIdentifierMethodField = BasicLazyInitializer.class.getDeclaredField("getIdentifierMethod");
                getIdentifierMethodField.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

