package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TbkActivityInfoGetResponse;

/**
 * TOP API: taobao.tbk.activity.info.get request
 * 
 * @author top auto create
 * @since 1.0, 2020.02.20
 */
public class TbkActivityInfoGetRequest extends BaseTaobaoRequest<TbkActivityInfoGetResponse> {
	
	

	/** 
	* 官方的物料id
	 */
	private String activityMaterialId;

	/** 
	* mm_xxx_xxx_xxx的第三位
	 */
	private Long adzoneId;

	/** 
	* 代理id
	 */
	private Long relationId;

	/** 
	* mm_xxx_xxx_xxx 仅三方分成场景使用
	 */
	private String subPid;

	public void setActivityMaterialId(String activityMaterialId) {
		this.activityMaterialId = activityMaterialId;
	}

	public String getActivityMaterialId() {
		return this.activityMaterialId;
	}

	public void setAdzoneId(Long adzoneId) {
		this.adzoneId = adzoneId;
	}

	public Long getAdzoneId() {
		return this.adzoneId;
	}

	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public Long getRelationId() {
		return this.relationId;
	}

	public void setSubPid(String subPid) {
		this.subPid = subPid;
	}

	public String getSubPid() {
		return this.subPid;
	}

	public String getApiMethodName() {
		return "taobao.tbk.activity.info.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("activity_material_id", this.activityMaterialId);
		txtParams.put("adzone_id", this.adzoneId);
		txtParams.put("relation_id", this.relationId);
		txtParams.put("sub_pid", this.subPid);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TbkActivityInfoGetResponse> getResponseClass() {
		return TbkActivityInfoGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(activityMaterialId, "activityMaterialId");
		RequestCheckUtils.checkNotEmpty(adzoneId, "adzoneId");
	}
	

}