package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TbkDgVegasSendReportResponse;

/**
 * TOP API: taobao.tbk.dg.vegas.send.report request
 * 
 * @author top auto create
 * @since 1.0, 2019.12.08
 */
public class TbkDgVegasSendReportRequest extends BaseTaobaoRequest<TbkDgVegasSendReportResponse> {
	
	

	/** 
	* 活动id
	 */
	private Long activityId;

	/** 
	* 统计日期
	 */
	private String bizDate;

	/** 
	* 页码
	 */
	private Long pageNo;

	/** 
	* 每页大小
	 */
	private Long pageSize;

	/** 
	* 代理id
	 */
	private Long relationId;

	public void setActivityId(Long activityId) {
		this.activityId = activityId;
	}

	public Long getActivityId() {
		return this.activityId;
	}

	public void setBizDate(String bizDate) {
		this.bizDate = bizDate;
	}

	public String getBizDate() {
		return this.bizDate;
	}

	public void setPageNo(Long pageNo) {
		this.pageNo = pageNo;
	}

	public Long getPageNo() {
		return this.pageNo;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public Long getRelationId() {
		return this.relationId;
	}

	public String getApiMethodName() {
		return "taobao.tbk.dg.vegas.send.report";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("activity_id", this.activityId);
		txtParams.put("biz_date", this.bizDate);
		txtParams.put("page_no", this.pageNo);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("relation_id", this.relationId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TbkDgVegasSendReportResponse> getResponseClass() {
		return TbkDgVegasSendReportResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(activityId, "activityId");
		RequestCheckUtils.checkNotEmpty(bizDate, "bizDate");
	}
	

}