package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TbkItemWordGetResponse;

/**
 * TOP API: taobao.tbk.item.word.get request
 * 
 * @author top auto create
 * @since 1.0, 2020.02.20
 */
public class TbkItemWordGetRequest extends BaseTaobaoRequest<TbkItemWordGetResponse> {
	
	

	/** 
	* 推广位
	 */
	private Long adzoneId;

	/** 
	* 期望获得词数量
	 */
	private Long count;

	/** 
	* 商品id，也有可能查询不到词
	 */
	private Long itemId;

	public void setAdzoneId(Long adzoneId) {
		this.adzoneId = adzoneId;
	}

	public Long getAdzoneId() {
		return this.adzoneId;
	}

	public void setCount(Long count) {
		this.count = count;
	}

	public Long getCount() {
		return this.count;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getItemId() {
		return this.itemId;
	}

	public String getApiMethodName() {
		return "taobao.tbk.item.word.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("adzone_id", this.adzoneId);
		txtParams.put("count", this.count);
		txtParams.put("item_id", this.itemId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TbkItemWordGetResponse> getResponseClass() {
		return TbkItemWordGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(itemId, "itemId");
	}
	

}