package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TbkOrderDetailsGetResponse;

/**
 * TOP API: taobao.tbk.order.details.get request
 * 
 * @author top auto create
 * @since 1.0, 2020.03.12
 */
public class TbkOrderDetailsGetRequest extends BaseTaobaoRequest<TbkOrderDetailsGetResponse> {
	
	

	/** 
	* 订单查询结束时间，订单开始时间至订单结束时间，中间时间段日常要求不超过3个小时，但如618、双11、年货节等大促期间预估时间段不可超过20分钟，超过会提示错误，调用时请务必注意时间段的选择，以保证亲能正常调用！
	 */
	private String endTime;

	/** 
	* 跳转类型，当向前或者向后翻页必须提供,-1: 向前翻页,1：向后翻页
	 */
	private Long jumpType;

	/** 
	* 推广者角色类型,2:二方，3:三方，不传，表示所有角色
	 */
	private Long memberType;

	/** 
	* 场景订单场景类型，1:常规订单，2:渠道订单，3:会员运营订单，默认为1
	 */
	private Long orderScene;

	/** 
	* 第几页，默认1，1~100
	 */
	private Long pageNo;

	/** 
	* 页大小，默认20，1~100
	 */
	private Long pageSize;

	/** 
	* 位点，除第一页之外，都需要传递；前端原样返回。
	 */
	private String positionIndex;

	/** 
	* 查询时间类型，1：按照订单淘客创建时间查询，2:按照订单淘客付款时间查询，3:按照订单淘客结算时间查询
	 */
	private Long queryType;

	/** 
	* 订单查询开始时间
	 */
	private String startTime;

	/** 
	* 淘客订单状态，12-付款，13-关闭，14-确认收货，3-结算成功;不传，表示所有状态
	 */
	private Long tkStatus;

	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	public String getEndTime() {
		return this.endTime;
	}

	public void setJumpType(Long jumpType) {
		this.jumpType = jumpType;
	}

	public Long getJumpType() {
		return this.jumpType;
	}

	public void setMemberType(Long memberType) {
		this.memberType = memberType;
	}

	public Long getMemberType() {
		return this.memberType;
	}

	public void setOrderScene(Long orderScene) {
		this.orderScene = orderScene;
	}

	public Long getOrderScene() {
		return this.orderScene;
	}

	public void setPageNo(Long pageNo) {
		this.pageNo = pageNo;
	}

	public Long getPageNo() {
		return this.pageNo;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setPositionIndex(String positionIndex) {
		this.positionIndex = positionIndex;
	}

	public String getPositionIndex() {
		return this.positionIndex;
	}

	public void setQueryType(Long queryType) {
		this.queryType = queryType;
	}

	public Long getQueryType() {
		return this.queryType;
	}

	public void setStartTime(String startTime) {
		this.startTime = startTime;
	}

	public String getStartTime() {
		return this.startTime;
	}

	public void setTkStatus(Long tkStatus) {
		this.tkStatus = tkStatus;
	}

	public Long getTkStatus() {
		return this.tkStatus;
	}

	public String getApiMethodName() {
		return "taobao.tbk.order.details.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("end_time", this.endTime);
		txtParams.put("jump_type", this.jumpType);
		txtParams.put("member_type", this.memberType);
		txtParams.put("order_scene", this.orderScene);
		txtParams.put("page_no", this.pageNo);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("position_index", this.positionIndex);
		txtParams.put("query_type", this.queryType);
		txtParams.put("start_time", this.startTime);
		txtParams.put("tk_status", this.tkStatus);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TbkOrderDetailsGetResponse> getResponseClass() {
		return TbkOrderDetailsGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(endTime, "endTime");
		RequestCheckUtils.checkNotEmpty(startTime, "startTime");
	}
	

}