package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TbkScPublisherInfoSaveResponse;

/**
 * TOP API: taobao.tbk.sc.publisher.info.save request
 * 
 * @author top auto create
 * @since 1.0, 2019.07.04
 */
public class TbkScPublisherInfoSaveRequest extends BaseTaobaoRequest<TbkScPublisherInfoSaveResponse> {
	
	

	/** 
	* 类型，必选 默认为1:
	 */
	private Long infoType;

	/** 
	* 渠道备案 - 淘宝客邀请渠道的邀请码
	 */
	private String inviterCode;

	/** 
	* 媒体侧渠道备注
	 */
	private String note;

	/** 
	* 渠道备案 - 线下场景信息，1 - 门店，2- 学校，3 - 工厂，4 - 其他
	 */
	private String offlineScene;

	/** 
	* 渠道备案 - 线上场景信息，1 - 微信群，2- QQ群，3 - 其他
	 */
	private String onlineScene;

	/** 
	* 线下备案注册信息,字段包含: 电话号码(phoneNumber，必填),省(province,必填),市(city,必填),区县街道(location,必填),详细地址(detailAddress,必填),经营类型(career,线下个人必填),店铺类型(shopType,线下店铺必填),店铺名称(shopName,线下店铺必填),店铺证书类型(shopCertifyType,线下店铺选填),店铺证书编号(certifyNumber,线下店铺选填)
	 */
	private String registerInfo;

	/** 
	* 渠道备案 - 来源，取链接的来源
	 */
	private String relationFrom;

	public void setInfoType(Long infoType) {
		this.infoType = infoType;
	}

	public Long getInfoType() {
		return this.infoType;
	}

	public void setInviterCode(String inviterCode) {
		this.inviterCode = inviterCode;
	}

	public String getInviterCode() {
		return this.inviterCode;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public String getNote() {
		return this.note;
	}

	public void setOfflineScene(String offlineScene) {
		this.offlineScene = offlineScene;
	}

	public String getOfflineScene() {
		return this.offlineScene;
	}

	public void setOnlineScene(String onlineScene) {
		this.onlineScene = onlineScene;
	}

	public String getOnlineScene() {
		return this.onlineScene;
	}

	public void setRegisterInfo(String registerInfo) {
		this.registerInfo = registerInfo;
	}

	public String getRegisterInfo() {
		return this.registerInfo;
	}

	public void setRelationFrom(String relationFrom) {
		this.relationFrom = relationFrom;
	}

	public String getRelationFrom() {
		return this.relationFrom;
	}

	public String getApiMethodName() {
		return "taobao.tbk.sc.publisher.info.save";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("info_type", this.infoType);
		txtParams.put("inviter_code", this.inviterCode);
		txtParams.put("note", this.note);
		txtParams.put("offline_scene", this.offlineScene);
		txtParams.put("online_scene", this.onlineScene);
		txtParams.put("register_info", this.registerInfo);
		txtParams.put("relation_from", this.relationFrom);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TbkScPublisherInfoSaveResponse> getResponseClass() {
		return TbkScPublisherInfoSaveResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(infoType, "infoType");
		RequestCheckUtils.checkNotEmpty(inviterCode, "inviterCode");
	}
	

}