/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.conf;

import com.adrninistrator.javacg.common.enums.JavaCGConfigKeyEnum;
import com.adrninistrator.javacg.common.enums.JavaCGOtherConfigFileUseListEnum;
import com.adrninistrator.javacg.common.enums.JavaCGOtherConfigFileUseSetEnum;
import com.adrninistrator.javacg.conf.JavaCGConfInfo;
import com.adrninistrator.javacg.conf.JavaCGConfigureWrapper;
import com.adrninistrator.javacg.util.JavaCGFileUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.io.BufferedReader;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class JavaCGConfManager {
    public static JavaCGConfInfo getConfInfo(JavaCGConfigureWrapper javaCGConfigureWrapper) {
        if (javaCGConfigureWrapper == null) {
            return null;
        }
        JavaCGConfInfo confInfo = new JavaCGConfInfo();
        String configFilePath = JavaCGConfManager.getInputRootPath() + "_javacg_config" + "/" + "config.properties";
        try (BufferedReader br = JavaCGFileUtil.genBufferedReader(JavaCGFileUtil.getFileInputStream(configFilePath));){
            Properties properties = new Properties();
            properties.load(br);
            confInfo.setParseMethodCallTypeValue(Boolean.parseBoolean(javaCGConfigureWrapper.getConfig(properties, JavaCGConfigKeyEnum.CKE_PARSE_METHOD_CALL_TYPE_VALUE, true)));
            confInfo.setFirstParseInitMethodType(Boolean.parseBoolean(javaCGConfigureWrapper.getConfig(properties, JavaCGConfigKeyEnum.CKE_FIRST_PARSE_INIT_METHOD_TYPE, true)));
            confInfo.setContinueWhenError(Boolean.parseBoolean(javaCGConfigureWrapper.getConfig(properties, JavaCGConfigKeyEnum.CKE_CONTINUE_WHEN_ERROR, true)));
            String debugPrintStr = javaCGConfigureWrapper.getConfig(properties, JavaCGConfigKeyEnum.CKE_DEBUG_PRINT, true);
            if ("file".equals(debugPrintStr)) {
                confInfo.setDebugPrint(true);
                confInfo.setDebugPrintInFile(true);
            } else if (Boolean.parseBoolean(debugPrintStr)) {
                confInfo.setDebugPrint(true);
                confInfo.setDebugPrintInFile(false);
            }
            confInfo.setLogMethodSpendTime(Boolean.parseBoolean(javaCGConfigureWrapper.getConfig(properties, JavaCGConfigKeyEnum.CKE_LOG_METHOD_SPEND_TIME, true)));
            String outputRootPath = javaCGConfigureWrapper.getConfig(properties, JavaCGConfigKeyEnum.CKE_OUTPUT_ROOT_PATH, true);
            confInfo.setOutputRootPath(outputRootPath);
            String outputFileExt = javaCGConfigureWrapper.getConfig(properties, JavaCGConfigKeyEnum.CKE_OUTPUT_FILE_EXT, true);
            if (StringUtils.isBlank((CharSequence)outputFileExt)) {
                confInfo.setOutputFileExt(".txt");
            } else {
                confInfo.setOutputFileExt(outputFileExt);
            }
        }
        catch (Exception e) {
            System.err.println("\u83b7\u53d6\u914d\u7f6e\u53c2\u6570\u51fa\u73b0\u5f02\u5e38");
            e.printStackTrace();
        }
        List<String> jarDirList = javaCGConfigureWrapper.getOtherConfigList(JavaCGOtherConfigFileUseListEnum.OCFULE_JAR_DIR, true);
        confInfo.setJarDirList(jarDirList);
        Set<String> needHandlePackageSet = javaCGConfigureWrapper.getOtherConfigSet(JavaCGOtherConfigFileUseSetEnum.OCFUSE_PACKAGES, true);
        confInfo.setNeedHandlePackageSet(needHandlePackageSet);
        return confInfo;
    }

    public static String getInputRootPath() {
        return JavaCGUtil.getDirPathInJvmOptions("input.root.path");
    }

    private JavaCGConfManager() {
        throw new IllegalStateException("illegal");
    }
}

