/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.dto.frame;

import com.adrninistrator.javacg.dto.frame.FieldInformation;
import com.adrninistrator.javacg.dto.frame.FrameSnapshotEntry;
import com.adrninistrator.javacg.dto.frame.JavaCGLocalVariables;
import com.adrninistrator.javacg.dto.frame.JavaCGOperandStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FrameSnapshotsOfIhs {
    private final Map<Integer, List<FrameSnapshotEntry>> frameSnapshotOfIhsMap = new HashMap<Integer, List<FrameSnapshotEntry>>();

    public List<FrameSnapshotEntry> get(Integer position) {
        return this.frameSnapshotOfIhsMap.get(position);
    }

    public boolean addSnapshot(int position, JavaCGOperandStack addedStack, JavaCGLocalVariables addedLocals, FieldInformation addedNonStaticFieldInfo, FieldInformation addedStaticFieldInfo) {
        List<FrameSnapshotEntry> frameSnapshotEntryList = this.frameSnapshotOfIhsMap.get(position);
        if (frameSnapshotEntryList == null) {
            frameSnapshotEntryList = new ArrayList<FrameSnapshotEntry>();
            frameSnapshotEntryList.add(new FrameSnapshotEntry(addedStack.copy(), addedLocals.copy(), addedNonStaticFieldInfo.copy(), addedStaticFieldInfo.copy()));
            this.frameSnapshotOfIhsMap.put(position, frameSnapshotEntryList);
            return true;
        }
        if (this.checkExistSnapshotLooseMode(frameSnapshotEntryList, addedStack, addedLocals, addedNonStaticFieldInfo, addedStaticFieldInfo)) {
            return false;
        }
        frameSnapshotEntryList.add(new FrameSnapshotEntry(addedStack.copy(), addedLocals.copy(), addedNonStaticFieldInfo.copy(), addedStaticFieldInfo.copy()));
        return true;
    }

    private boolean checkExistSnapshotLooseMode(List<FrameSnapshotEntry> frameSnapshotEntryList, JavaCGOperandStack addedStack, JavaCGLocalVariables addedLocals, FieldInformation addedNonStaticFieldInfo, FieldInformation addedStaticFieldInfo) {
        int addedStackSize = addedStack.size();
        int addedLocalsSize = addedLocals.size();
        int addedNonStaticFieldInfoSize = addedNonStaticFieldInfo.size();
        int addedStaticFieldInfoSize = addedStaticFieldInfo.size();
        HashSet<Integer> sameStackSeqSet = new HashSet<Integer>(addedStackSize);
        HashSet<Integer> sameLocalsSeqSet = new HashSet<Integer>(addedLocalsSize);
        HashSet<String> sameNonStaticFieldInfoNameSet = new HashSet<String>(addedNonStaticFieldInfoSize);
        HashSet<String> sameStaticFieldInfoNameSet = new HashSet<String>(addedStaticFieldInfoSize);
        for (FrameSnapshotEntry frameSnapshotEntry : frameSnapshotEntryList) {
            boolean equals = true;
            if (addedStackSize != sameStackSeqSet.size()) {
                JavaCGOperandStack.compareLooseMode(frameSnapshotEntry.getStackSnapshot(), addedStack, sameStackSeqSet);
                if (addedStackSize != sameStackSeqSet.size()) {
                    equals = false;
                }
            }
            if (addedLocalsSize != sameLocalsSeqSet.size()) {
                JavaCGLocalVariables.compareLooseMode(frameSnapshotEntry.getLocalsSnapshot(), addedLocals, sameLocalsSeqSet);
                if (addedLocalsSize != sameLocalsSeqSet.size()) {
                    equals = false;
                }
            }
            if (addedNonStaticFieldInfoSize != sameNonStaticFieldInfoNameSet.size()) {
                FieldInformation.compareLooseMode(frameSnapshotEntry.getNonStaticFieldInfo(), addedNonStaticFieldInfo, sameNonStaticFieldInfoNameSet);
                if (addedNonStaticFieldInfoSize != sameNonStaticFieldInfoNameSet.size()) {
                    equals = false;
                }
            }
            if (addedStaticFieldInfoSize != sameStaticFieldInfoNameSet.size()) {
                FieldInformation.compareLooseMode(frameSnapshotEntry.getStaticFieldInfo(), addedStaticFieldInfo, sameStaticFieldInfoNameSet);
                if (addedStaticFieldInfoSize != sameStaticFieldInfoNameSet.size()) {
                    equals = false;
                }
            }
            if (!equals) continue;
            return true;
        }
        return false;
    }
}

