/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.handler;

import com.adrninistrator.javacg.conf.JavaCGConfInfo;
import com.adrninistrator.javacg.dto.counter.JavaCGCounter;
import com.adrninistrator.javacg.dto.field.FieldPossibleTypes;
import com.adrninistrator.javacg.dto.jar.ClassAndJarNum;
import com.adrninistrator.javacg.extensions.annotation_attributes.AnnotationAttributesFormatterInterface;
import com.adrninistrator.javacg.extensions.manager.ExtensionsManager;
import com.adrninistrator.javacg.handler.MethodHandler4Invoke;
import com.adrninistrator.javacg.handler.MethodHandler4TypeAndValue;
import com.adrninistrator.javacg.spring.UseSpringBeanByAnnotationHandler;
import com.adrninistrator.javacg.util.JavaCGAnnotationUtil;
import com.adrninistrator.javacg.util.JavaCGByteCodeUtil;
import com.adrninistrator.javacg.util.JavaCGFileUtil;
import com.adrninistrator.javacg.util.JavaCGMethodUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import com.adrninistrator.javacg.writer.WriterSupportSkip;
import copy.javassist.bytecode.BadBytecode;
import copy.javassist.bytecode.SignatureAttribute;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.commons.lang3.ArrayUtils;

public class ClassHandler {
    private final JavaClass javaClass;
    private final String classFileName;
    private final ConstantPoolGen cpg;
    private final Set<String> handledMethodNameAndArgs;
    private UseSpringBeanByAnnotationHandler useSpringBeanByAnnotationHandler;
    private Map<String, Boolean> runnableImplClassMap;
    private Map<String, Boolean> callableImplClassMap;
    private Map<String, Boolean> transactionCallbackImplClassMap;
    private Map<String, Boolean> transactionCallbackWithoutResultChildClassMap;
    private Map<String, Boolean> threadChildClassMap;
    private ExtensionsManager extensionsManager;
    private JavaCGCounter callIdCounter;
    private JavaCGCounter methodNumCounter;
    private Writer classNameWriter;
    private Writer methodCallWriter;
    private Writer lambdaMethodInfoWriter;
    private Writer classAnnotationWriter;
    private Writer methodAnnotationWriter;
    private Writer methodLineNumberWriter;
    private Writer methodCallInfoWriter;
    private Writer methodInfoWriter;
    private Writer methodArgGenericsTypeWriter;
    private Writer methodReturnGenericsTypeWriter;
    private WriterSupportSkip logMethodSpendTimeWriter;
    private AnnotationAttributesFormatterInterface annotationAttributesFormatter;
    private final JavaCGConfInfo javaCGConfInfo;
    private int lastJarNum;
    private ClassAndJarNum classAndJarNum;
    private FieldPossibleTypes nonStaticFieldPossibleTypes;

    public ClassHandler(JavaClass javaClass, String classFileName, JavaCGConfInfo javaCGConfInfo) {
        this.javaClass = javaClass;
        this.classFileName = classFileName;
        this.javaCGConfInfo = javaCGConfInfo;
        this.cpg = new ConstantPoolGen(javaClass.getConstantPool());
        this.handledMethodNameAndArgs = new HashSet<String>();
        if (javaCGConfInfo.isFirstParseInitMethodType()) {
            this.nonStaticFieldPossibleTypes = new FieldPossibleTypes();
        }
    }

    private void recordReferencedClass() throws IOException {
        String className = this.javaClass.getClassName();
        ConstantPool constantPool = this.javaClass.getConstantPool();
        HashSet<String> referencedClassSet = new HashSet<String>();
        for (int i = 0; i < constantPool.getLength(); ++i) {
            String referencedClass;
            Constant constant = null;
            try {
                constant = constantPool.getConstant(i);
            }
            catch (ClassFormatException classFormatException) {
                // empty catch block
            }
            if (constant == null || constant.getTag() != 7 || JavaCGUtil.isObjectClass(referencedClass = constantPool.constantToString(constant))) continue;
            referencedClass = JavaCGByteCodeUtil.removeArrayInClassName(referencedClass);
            referencedClassSet.add(referencedClass);
        }
        if (!JavaCGUtil.checkSkipClass(className, this.javaCGConfInfo.getNeedHandlePackageSet())) {
            JavaCGFileUtil.write2FileWithTab(this.classNameWriter, "#");
            JavaCGFileUtil.write2FileWithTab(this.classNameWriter, className);
        }
        ArrayList referencedClassList = new ArrayList(referencedClassSet);
        Collections.sort(referencedClassList);
        for (String referencedClass : referencedClassList) {
            if (JavaCGUtil.checkSkipClass(referencedClass, this.javaCGConfInfo.getNeedHandlePackageSet()) || className.equals(referencedClass)) continue;
            JavaCGFileUtil.write2FileWithTab(this.classNameWriter, referencedClass);
        }
    }

    public boolean handleClass() throws IOException {
        this.recordReferencedClass();
        if (!this.javaClass.isAnnotation()) {
            JavaCGAnnotationUtil.writeAnnotationInfo(this.javaClass.getClassName(), this.javaClass.getAnnotationEntries(), this.annotationAttributesFormatter, this.classAnnotationWriter);
        }
        if (this.javaCGConfInfo.isFirstParseInitMethodType()) {
            for (Method method : this.javaClass.getMethods()) {
                if (!"<init>".equals(method.getName()) || this.parseInitMethod(method)) continue;
                return false;
            }
        }
        for (Method method : this.javaClass.getMethods()) {
            if (this.handleMethod(method)) continue;
            return false;
        }
        return true;
    }

    private boolean parseInitMethod(Method method) {
        MethodGen mg = new MethodGen(method, this.javaClass.getClassName(), this.cpg);
        MethodHandler4TypeAndValue methodHandler4TypeAndValue = new MethodHandler4TypeAndValue(mg, this.javaClass, this.javaCGConfInfo);
        methodHandler4TypeAndValue.setRecordFieldPossibleTypeFlag(true);
        methodHandler4TypeAndValue.setUseFieldPossibleTypeFlag(false);
        methodHandler4TypeAndValue.setNonStaticFieldPossibleTypes(this.nonStaticFieldPossibleTypes);
        return methodHandler4TypeAndValue.handleMethod();
    }

    private boolean handleMethod(Method method) throws IOException {
        String methodGenericSignature;
        this.methodNumCounter.addAndGet();
        boolean existsSameMethodNameAndArgs = false;
        String className = this.javaClass.getClassName();
        String callerMethodArgs = JavaCGMethodUtil.getArgListStr(method.getArgumentTypes());
        String fullMethod = JavaCGMethodUtil.formatFullMethod(className, method.getName(), callerMethodArgs);
        String returnType = method.getReturnType().toString();
        String methodNameAndArgs = method.getName() + callerMethodArgs;
        if (!this.handledMethodNameAndArgs.contains(methodNameAndArgs)) {
            JavaCGFileUtil.write2FileWithTab(this.methodInfoWriter, fullMethod, String.valueOf(method.getAccessFlags()), returnType);
        } else {
            existsSameMethodNameAndArgs = true;
            if (!JavaCGByteCodeUtil.isBridgeFlag(method.getAccessFlags())) {
                System.err.println("\u51fa\u73b0\u65b9\u6cd5\u540d+\u53c2\u6570\u7c7b\u578b\u5747\u76f8\u540c\u7684\u65b9\u6cd5\uff0c\u4f46\u65b9\u6cd5\u6ca1\u6709ACC_BRIDGE\u6807\u5fd7\uff0c\u4e0e\u9884\u671f\u4e0d\u7b26 " + className + " " + methodNameAndArgs);
            }
        }
        long startTime = 0L;
        if (this.javaCGConfInfo.isLogMethodSpendTime()) {
            startTime = System.currentTimeMillis();
            this.logMethodSpendTimeWriter.write(this.classFileName + "\t" + fullMethod);
        }
        if ((methodGenericSignature = method.getGenericSignature()) != null) {
            try {
                SignatureAttribute.MethodSignature methodSignature = SignatureAttribute.toMethodSignature(methodGenericSignature);
                this.recordMethodReturnGenericsType(fullMethod, methodSignature);
                this.recordMethodArgsGenericsType(fullMethod, methodSignature);
            }
            catch (BadBytecode e) {
                System.err.println("\u5904\u7406\u65b9\u6cd5\u7b7e\u540d\u51fa\u73b0\u5f02\u5e38: " + fullMethod);
                e.printStackTrace();
            }
        }
        MethodGen mg = new MethodGen(method, className, this.cpg);
        MethodHandler4Invoke methodHandler4Invoke = new MethodHandler4Invoke(mg, this.javaClass, this.javaCGConfInfo, callerMethodArgs, fullMethod, this.useSpringBeanByAnnotationHandler, this.callIdCounter);
        methodHandler4Invoke.setRunnableImplClassMap(this.runnableImplClassMap);
        methodHandler4Invoke.setCallableImplClassMap(this.callableImplClassMap);
        methodHandler4Invoke.setTransactionCallbackImplClassMap(this.transactionCallbackImplClassMap);
        methodHandler4Invoke.setTransactionCallbackWithoutResultChildClassMap(this.transactionCallbackWithoutResultChildClassMap);
        methodHandler4Invoke.setThreadChildClassMap(this.threadChildClassMap);
        methodHandler4Invoke.setExtensionsManager(this.extensionsManager);
        methodHandler4Invoke.setMethodCallWriter(this.methodCallWriter);
        methodHandler4Invoke.setLambdaMethodInfoWriter(this.lambdaMethodInfoWriter);
        methodHandler4Invoke.setMethodAnnotationWriter(this.methodAnnotationWriter);
        methodHandler4Invoke.setMethodLineNumberWriter(this.methodLineNumberWriter);
        methodHandler4Invoke.setMethodCallInfoWriter(this.methodCallInfoWriter);
        methodHandler4Invoke.setParseMethodCallTypeValueFlag(this.javaCGConfInfo.isParseMethodCallTypeValue());
        methodHandler4Invoke.setLastJarNum(this.lastJarNum);
        methodHandler4Invoke.setExistsSameMethodNameAndArgs(existsSameMethodNameAndArgs);
        methodHandler4Invoke.setClassAndJarNum(this.classAndJarNum);
        if (this.javaCGConfInfo.isFirstParseInitMethodType()) {
            methodHandler4Invoke.setNonStaticFieldPossibleTypes(this.nonStaticFieldPossibleTypes);
        }
        this.handledMethodNameAndArgs.add(methodNameAndArgs);
        boolean success = methodHandler4Invoke.handleMethod();
        if (this.javaCGConfInfo.isLogMethodSpendTime()) {
            long spendTime = System.currentTimeMillis() - startTime;
            this.logMethodSpendTimeWriter.write("\t" + spendTime + "\n");
        }
        return success;
    }

    private void recordMethodReturnGenericsType(String fullMethod, SignatureAttribute.MethodSignature methodSignature) {
        try {
            SignatureAttribute.Type returnType = methodSignature.getReturnType();
            if (!(returnType instanceof SignatureAttribute.ClassType)) {
                return;
            }
            SignatureAttribute.ClassType classType = (SignatureAttribute.ClassType)returnType;
            ArrayList<String> methodReturnGenericsTypeList = new ArrayList<String>();
            this.parseMethodArgsGenericsType(classType, true, methodReturnGenericsTypeList);
            if (methodReturnGenericsTypeList.isEmpty()) {
                return;
            }
            JavaCGFileUtil.write2FileWithTab(this.methodReturnGenericsTypeWriter, fullMethod, "t", String.valueOf(0), classType.getName());
            for (int i = 0; i < methodReturnGenericsTypeList.size(); ++i) {
                JavaCGFileUtil.write2FileWithTab(this.methodReturnGenericsTypeWriter, fullMethod, "gt", String.valueOf(i), (String)methodReturnGenericsTypeList.get(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void recordMethodArgsGenericsType(String fullMethod, SignatureAttribute.MethodSignature methodSignature) throws IOException {
        Object[] parameterTypes = methodSignature.getParameterTypes();
        if (ArrayUtils.isEmpty((Object[])parameterTypes)) {
            return;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Object argType = parameterTypes[i];
            if (!(argType instanceof SignatureAttribute.ClassType)) continue;
            SignatureAttribute.ClassType classType = (SignatureAttribute.ClassType)argType;
            ArrayList<String> methodArgsGenericsTypeList = new ArrayList<String>();
            this.parseMethodArgsGenericsType(classType, true, methodArgsGenericsTypeList);
            if (methodArgsGenericsTypeList.isEmpty()) continue;
            JavaCGFileUtil.write2FileWithTab(this.methodArgGenericsTypeWriter, fullMethod, String.valueOf(i), "t", String.valueOf(0), classType.getName());
            for (int j = 0; j < methodArgsGenericsTypeList.size(); ++j) {
                JavaCGFileUtil.write2FileWithTab(this.methodArgGenericsTypeWriter, fullMethod, String.valueOf(i), "gt", String.valueOf(j), (String)methodArgsGenericsTypeList.get(j));
            }
        }
    }

    private void parseMethodArgsGenericsType(SignatureAttribute.Type type, boolean outer, List<String> methodArgsGenericsTypeList) {
        if (!(type instanceof SignatureAttribute.ClassType)) {
            return;
        }
        SignatureAttribute.ClassType classType = (SignatureAttribute.ClassType)type;
        Object[] typeArguments = classType.getTypeArguments();
        if (ArrayUtils.isEmpty((Object[])typeArguments)) {
            if (outer) {
                return;
            }
            methodArgsGenericsTypeList.add(classType.getName());
            return;
        }
        if (!outer) {
            methodArgsGenericsTypeList.add(classType.getName());
        }
        for (Object typeArgument : typeArguments) {
            this.parseMethodArgsGenericsType(((SignatureAttribute.TypeArgument)typeArgument).getType(), false, methodArgsGenericsTypeList);
        }
    }

    public void setUseSpringBeanByAnnotationHandler(UseSpringBeanByAnnotationHandler useSpringBeanByAnnotationHandler) {
        this.useSpringBeanByAnnotationHandler = useSpringBeanByAnnotationHandler;
    }

    public void setRunnableImplClassMap(Map<String, Boolean> runnableImplClassMap) {
        this.runnableImplClassMap = runnableImplClassMap;
    }

    public void setCallableImplClassMap(Map<String, Boolean> callableImplClassMap) {
        this.callableImplClassMap = callableImplClassMap;
    }

    public void setTransactionCallbackImplClassMap(Map<String, Boolean> transactionCallbackImplClassMap) {
        this.transactionCallbackImplClassMap = transactionCallbackImplClassMap;
    }

    public void setTransactionCallbackWithoutResultChildClassMap(Map<String, Boolean> transactionCallbackWithoutResultChildClassMap) {
        this.transactionCallbackWithoutResultChildClassMap = transactionCallbackWithoutResultChildClassMap;
    }

    public void setThreadChildClassMap(Map<String, Boolean> threadChildClassMap) {
        this.threadChildClassMap = threadChildClassMap;
    }

    public void setExtensionsManager(ExtensionsManager extensionsManager) {
        this.extensionsManager = extensionsManager;
        this.annotationAttributesFormatter = extensionsManager.getAnnotationAttributesFormatter();
    }

    public void setCallIdCounter(JavaCGCounter callIdCounter) {
        this.callIdCounter = callIdCounter;
    }

    public void setClassNameWriter(Writer classNameWriter) {
        this.classNameWriter = classNameWriter;
    }

    public void setMethodCallWriter(Writer methodCallWriter) {
        this.methodCallWriter = methodCallWriter;
    }

    public void setLambdaMethodInfoWriter(Writer lambdaMethodInfoWriter) {
        this.lambdaMethodInfoWriter = lambdaMethodInfoWriter;
    }

    public void setClassAnnotationWriter(Writer classAnnotationWriter) {
        this.classAnnotationWriter = classAnnotationWriter;
    }

    public void setMethodAnnotationWriter(Writer methodAnnotationWriter) {
        this.methodAnnotationWriter = methodAnnotationWriter;
    }

    public void setMethodLineNumberWriter(Writer methodLineNumberWriter) {
        this.methodLineNumberWriter = methodLineNumberWriter;
    }

    public void setMethodCallInfoWriter(Writer methodCallInfoWriter) {
        this.methodCallInfoWriter = methodCallInfoWriter;
    }

    public void setMethodInfoWriter(Writer methodInfoWriter) {
        this.methodInfoWriter = methodInfoWriter;
    }

    public void setMethodArgGenericsTypeWriter(Writer methodArgGenericsTypeWriter) {
        this.methodArgGenericsTypeWriter = methodArgGenericsTypeWriter;
    }

    public void setMethodReturnGenericsTypeWriter(Writer methodReturnGenericsTypeWriter) {
        this.methodReturnGenericsTypeWriter = methodReturnGenericsTypeWriter;
    }

    public void setLogMethodSpendTimeWriter(WriterSupportSkip logMethodSpendTimeWriter) {
        this.logMethodSpendTimeWriter = logMethodSpendTimeWriter;
    }

    public void setMethodNumCounter(JavaCGCounter methodNumCounter) {
        this.methodNumCounter = methodNumCounter;
    }

    public void setLastJarNum(int lastJarNum) {
        this.lastJarNum = lastJarNum;
    }

    public void setClassAndJarNum(ClassAndJarNum classAndJarNum) {
        this.classAndJarNum = classAndJarNum;
    }
}

