/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.handler;

import com.adrninistrator.javacg.common.enums.JavaCGCallTypeEnum;
import com.adrninistrator.javacg.comparator.MethodAndArgsComparator;
import com.adrninistrator.javacg.conf.JavaCGConfInfo;
import com.adrninistrator.javacg.dto.access_flag.JavaCGAccessFlags;
import com.adrninistrator.javacg.dto.call.MethodCall;
import com.adrninistrator.javacg.dto.classes.ClassExtendsMethodInfo;
import com.adrninistrator.javacg.dto.classes.ClassImplementsMethodInfo;
import com.adrninistrator.javacg.dto.classes.Node4ClassExtendsMethod;
import com.adrninistrator.javacg.dto.counter.JavaCGCounter;
import com.adrninistrator.javacg.dto.interfaces.InterfaceExtendsMethodInfo;
import com.adrninistrator.javacg.dto.jar.ClassAndJarNum;
import com.adrninistrator.javacg.dto.method.MethodAndArgs;
import com.adrninistrator.javacg.dto.stack.ListAsStack;
import com.adrninistrator.javacg.util.JavaCGByteCodeUtil;
import com.adrninistrator.javacg.util.JavaCGFileUtil;
import com.adrninistrator.javacg.util.JavaCGLogUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ExtendsImplHandler {
    private JavaCGConfInfo javaCGConfInfo;
    private JavaCGCounter callIdCounter;
    private Map<String, List<MethodAndArgs>> interfaceMethodWithArgsMap;
    private Map<String, List<String>> childrenClassMap;
    private Map<String, InterfaceExtendsMethodInfo> interfaceExtendsMethodInfoMap;
    private Map<String, List<String>> childrenInterfaceMap;
    private Map<String, ClassImplementsMethodInfo> classImplementsMethodInfoMap;
    private Map<String, ClassExtendsMethodInfo> classExtendsMethodInfoMap;
    private ClassAndJarNum classAndJarNum;

    public void handle(Writer methodCallWriter) throws IOException {
        this.addSuperInterfaceMethod4ChildrenInterface(methodCallWriter);
        this.addInterfaceMethod4SuperAbstractClass();
        this.recordClassExtendsMethod(methodCallWriter);
        this.recordInterfaceCallClassMethod(methodCallWriter);
    }

    private void addSuperInterfaceMethod4ChildrenInterface(Writer methodCallWriter) throws IOException {
        HashSet<String> topSuperInterfaceSet = new HashSet<String>();
        for (Map.Entry<String, InterfaceExtendsMethodInfo> entry : this.interfaceExtendsMethodInfoMap.entrySet()) {
            InterfaceExtendsMethodInfo interfaceExtendsMethodInfo = entry.getValue();
            for (String superInterface : interfaceExtendsMethodInfo.getSuperInterfaceList()) {
                InterfaceExtendsMethodInfo superInterfaceExtendsMethodInfo = this.interfaceExtendsMethodInfoMap.get(superInterface);
                if (superInterfaceExtendsMethodInfo != null && !superInterfaceExtendsMethodInfo.getSuperInterfaceList().isEmpty() || !topSuperInterfaceSet.add(superInterface) || !JavaCGLogUtil.isDebugPrintFlag()) continue;
                JavaCGLogUtil.debugPrint("\u5904\u7406\u4e00\u4e2a\u9876\u5c42\u7236\u63a5\u53e3: " + superInterface);
            }
        }
        ArrayList topSuperInterfaceSetList = new ArrayList(topSuperInterfaceSet);
        Collections.sort(topSuperInterfaceSetList);
        for (String topSuperInterface : topSuperInterfaceSetList) {
            this.handleOneSuperInterface(topSuperInterface, methodCallWriter);
        }
    }

    private void handleOneSuperInterface(String superInterface, Writer methodCallWriter) throws IOException {
        List<String> childrenInterfaceList = this.childrenInterfaceMap.get(superInterface);
        if (childrenInterfaceList == null) {
            return;
        }
        for (String childrenInterface : childrenInterfaceList) {
            this.handleSuperAndChildInterface(superInterface, childrenInterface, methodCallWriter);
            this.handleOneSuperInterface(childrenInterface, methodCallWriter);
        }
    }

    private void handleSuperAndChildInterface(String superInterface, String childInterface, Writer methodCallWriter) throws IOException {
        InterfaceExtendsMethodInfo superInterfaceExtendsMethodInfo = this.interfaceExtendsMethodInfoMap.get(superInterface);
        if (superInterfaceExtendsMethodInfo == null) {
            return;
        }
        InterfaceExtendsMethodInfo childInterfaceExtendsMethodInfo = this.interfaceExtendsMethodInfoMap.get(childInterface);
        List<MethodAndArgs> superInterfaceMethodAndArgsList = superInterfaceExtendsMethodInfo.getMethodAndArgsList();
        superInterfaceMethodAndArgsList.sort(MethodAndArgsComparator.getInstance());
        for (MethodAndArgs superMethodAndArgs : superInterfaceMethodAndArgsList) {
            List<MethodAndArgs> childInterfaceMethodAndArgsList = childInterfaceExtendsMethodInfo.getMethodAndArgsList();
            if (childInterfaceMethodAndArgsList.contains(superMethodAndArgs)) continue;
            childInterfaceMethodAndArgsList.add(superMethodAndArgs);
            List childInterfaceMethodAndArgsListAll = this.interfaceMethodWithArgsMap.computeIfAbsent(childInterface, k -> new ArrayList());
            childInterfaceMethodAndArgsListAll.add(superMethodAndArgs);
            this.addExtraMethodCall(methodCallWriter, childInterface, superMethodAndArgs.getMethodName(), superMethodAndArgs.getMethodArgs(), JavaCGCallTypeEnum.CTE_CHILD_CALL_SUPER_INTERFACE, superInterface, superMethodAndArgs.getMethodName(), superMethodAndArgs.getMethodArgs());
        }
    }

    private void addInterfaceMethod4SuperAbstractClass() {
        for (Map.Entry<String, List<String>> childrenClassEntry : this.childrenClassMap.entrySet()) {
            ClassImplementsMethodInfo classImplementsMethodInfo;
            String superClassName = childrenClassEntry.getKey();
            ClassExtendsMethodInfo classExtendsMethodInfo = this.classExtendsMethodInfoMap.get(superClassName);
            if (classExtendsMethodInfo == null || !JavaCGByteCodeUtil.isAbstractFlag(classExtendsMethodInfo.getAccessFlags()) || (classImplementsMethodInfo = this.classImplementsMethodInfoMap.get(superClassName)) == null) continue;
            Map<MethodAndArgs, Integer> methodWithArgsMap = classExtendsMethodInfo.getMethodWithArgsMap();
            int accessFlags = 0;
            accessFlags = JavaCGByteCodeUtil.setAbstractFlag(accessFlags, true);
            accessFlags = JavaCGByteCodeUtil.setPublicFlag(accessFlags, true);
            accessFlags = JavaCGByteCodeUtil.setProtectedFlag(accessFlags, false);
            for (String interfaceName : classImplementsMethodInfo.getInterfaceNameList()) {
                List<MethodAndArgs> interfaceMethodWithArgsList = this.interfaceMethodWithArgsMap.get(interfaceName);
                if (interfaceMethodWithArgsList == null) continue;
                for (MethodAndArgs interfaceMethodWithArgs : interfaceMethodWithArgsList) {
                    methodWithArgsMap.putIfAbsent(interfaceMethodWithArgs, accessFlags);
                }
            }
        }
    }

    private void recordClassExtendsMethod(Writer methodCallWriter) throws IOException {
        HashSet<String> topSuperClassNameSet = new HashSet<String>();
        for (Map.Entry<String, ClassExtendsMethodInfo> classExtendsMethodInfoEntry : this.classExtendsMethodInfoMap.entrySet()) {
            String className = classExtendsMethodInfoEntry.getKey();
            ClassExtendsMethodInfo classExtendsMethodInfo = classExtendsMethodInfoEntry.getValue();
            String superClassName = classExtendsMethodInfo.getSuperClassName();
            if (!JavaCGUtil.isClassInJdk(superClassName)) continue;
            topSuperClassNameSet.add(className);
        }
        ArrayList topSuperClassNameList = new ArrayList(topSuperClassNameSet);
        Collections.sort(topSuperClassNameList);
        for (String topSuperClassName : topSuperClassNameList) {
            this.handleOneTopSuperClass(topSuperClassName, methodCallWriter);
        }
    }

    private void handleOneTopSuperClass(String topSuperClassName, Writer methodCallWriter) throws IOException {
        if (JavaCGLogUtil.isDebugPrintFlag()) {
            JavaCGLogUtil.debugPrint("\u5904\u7406\u4e00\u4e2a\u9876\u5c42\u7236\u7c7b: " + topSuperClassName);
        }
        ListAsStack<Node4ClassExtendsMethod> nodeStack = new ListAsStack<Node4ClassExtendsMethod>();
        Node4ClassExtendsMethod topNode = new Node4ClassExtendsMethod(topSuperClassName, -1);
        nodeStack.push(topNode);
        while (true) {
            Node4ClassExtendsMethod currentNode;
            List<String> childrenClassList;
            if ((childrenClassList = this.childrenClassMap.get((currentNode = (Node4ClassExtendsMethod)nodeStack.peek()).getSuperClassName())) == null) {
                System.err.println("### \u672a\u627e\u5230\u9876\u5c42\u7236\u7c7b\u7684\u5b50\u7c7b: " + currentNode.getSuperClassName());
                return;
            }
            Collections.sort(childrenClassList);
            int currentChildClassIndex = currentNode.getChildClassIndex() + 1;
            if (currentChildClassIndex >= childrenClassList.size()) {
                if (nodeStack.atBottom()) {
                    return;
                }
                nodeStack.removeTop();
                continue;
            }
            String childClassName = childrenClassList.get(currentChildClassIndex);
            this.handleSuperAndChildClass(currentNode.getSuperClassName(), childClassName, methodCallWriter);
            currentNode.setChildClassIndex(currentChildClassIndex);
            List<String> nextChildClassList = this.childrenClassMap.get(childClassName);
            if (nextChildClassList == null) continue;
            Node4ClassExtendsMethod nextNode = new Node4ClassExtendsMethod(childClassName, -1);
            nodeStack.push(nextNode);
        }
    }

    private void handleSuperAndChildClass(String superClassName, String childClassName, Writer methodCallWriter) throws IOException {
        ClassExtendsMethodInfo superClassMethodInfo = this.classExtendsMethodInfoMap.get(superClassName);
        if (superClassMethodInfo == null) {
            System.err.println("### \u672a\u627e\u5230\u7236\u7c7b\u4fe1\u606f: " + superClassName);
            return;
        }
        ClassExtendsMethodInfo childClassMethodInfo = this.classExtendsMethodInfoMap.get(childClassName);
        if (childClassMethodInfo == null) {
            System.err.println("### \u672a\u627e\u5230\u5b50\u7c7b\u4fe1\u606f: " + childClassName);
            return;
        }
        Map<MethodAndArgs, Integer> superMethodWithArgsMap = superClassMethodInfo.getMethodWithArgsMap();
        Map<MethodAndArgs, Integer> childMethodWithArgsMap = childClassMethodInfo.getMethodWithArgsMap();
        ArrayList<MethodAndArgs> superMethodAndArgsList = new ArrayList<MethodAndArgs>(superMethodWithArgsMap.keySet());
        superMethodAndArgsList.sort(MethodAndArgsComparator.getInstance());
        for (MethodAndArgs superMethodWithArgs : superMethodAndArgsList) {
            Integer superMethodAccessFlags = superMethodWithArgsMap.get(superMethodWithArgs);
            if (JavaCGByteCodeUtil.isAbstractFlag(superMethodAccessFlags)) {
                childMethodWithArgsMap.putIfAbsent(superMethodWithArgs, superMethodAccessFlags);
                this.addExtraMethodCall(methodCallWriter, superClassName, superMethodWithArgs.getMethodName(), superMethodWithArgs.getMethodArgs(), JavaCGCallTypeEnum.CTE_SUPER_CALL_CHILD, childClassName, superMethodWithArgs.getMethodName(), superMethodWithArgs.getMethodArgs());
                continue;
            }
            if (!JavaCGByteCodeUtil.isPublicFlag(superMethodAccessFlags) && !JavaCGByteCodeUtil.isProtectedMethod(superMethodAccessFlags) && (JavaCGByteCodeUtil.isPrivateMethod(superMethodAccessFlags) || !JavaCGUtil.checkSamePackage(superClassName, childClassName)) || childMethodWithArgsMap.get(superMethodWithArgs) != null) continue;
            childMethodWithArgsMap.put(superMethodWithArgs, superMethodAccessFlags);
            this.addExtraMethodCall(methodCallWriter, childClassName, superMethodWithArgs.getMethodName(), superMethodWithArgs.getMethodArgs(), JavaCGCallTypeEnum.CTE_CHILD_CALL_SUPER, superClassName, superMethodWithArgs.getMethodName(), superMethodWithArgs.getMethodArgs());
        }
    }

    private void recordInterfaceCallClassMethod(Writer methodCallWriter) throws IOException {
        if (this.classImplementsMethodInfoMap.isEmpty() || this.interfaceMethodWithArgsMap.isEmpty()) {
            return;
        }
        ArrayList<String> classNameList = new ArrayList<String>(this.classImplementsMethodInfoMap.keySet());
        Collections.sort(classNameList);
        for (String className : classNameList) {
            ClassImplementsMethodInfo classImplementsMethodInfo = this.classImplementsMethodInfoMap.get(className);
            List<String> interfaceNameList = classImplementsMethodInfo.getInterfaceNameList();
            Collections.sort(interfaceNameList);
            for (String interfaceName : interfaceNameList) {
                List<MethodAndArgs> interfaceMethodWithArgsList = this.interfaceMethodWithArgsMap.get(interfaceName);
                if (JavaCGUtil.isCollectionEmpty(interfaceMethodWithArgsList)) continue;
                List<MethodAndArgs> methodWithArgsList = classImplementsMethodInfo.getMethodWithArgsList();
                this.addSuperMethod2ImplClass(methodWithArgsList, className);
                methodWithArgsList.sort(MethodAndArgsComparator.getInstance());
                for (MethodAndArgs methodWithArgs : methodWithArgsList) {
                    if (!interfaceMethodWithArgsList.contains(methodWithArgs)) continue;
                    this.addExtraMethodCall(methodCallWriter, interfaceName, methodWithArgs.getMethodName(), methodWithArgs.getMethodArgs(), JavaCGCallTypeEnum.CTE_INTERFACE_CALL_IMPL_CLASS, className, methodWithArgs.getMethodName(), methodWithArgs.getMethodArgs());
                }
            }
        }
    }

    private void addSuperMethod2ImplClass(List<MethodAndArgs> methodWithArgsList, String className) {
        ClassExtendsMethodInfo classExtendsMethodInfo = this.classExtendsMethodInfoMap.get(className);
        if (classExtendsMethodInfo == null) {
            return;
        }
        Map<MethodAndArgs, Integer> methodWithArgsMap = classExtendsMethodInfo.getMethodWithArgsMap();
        if (methodWithArgsMap == null) {
            return;
        }
        for (Map.Entry<MethodAndArgs, Integer> entry : methodWithArgsMap.entrySet()) {
            JavaCGAccessFlags methodAccessFlags;
            String methodName;
            MethodAndArgs methodAndArgs = entry.getKey();
            if (methodWithArgsList.contains(methodAndArgs) || !JavaCGByteCodeUtil.checkImplMethod(methodName = methodAndArgs.getMethodName(), methodAccessFlags = new JavaCGAccessFlags(entry.getValue()))) continue;
            methodWithArgsList.add(methodAndArgs);
        }
    }

    private void addExtraMethodCall(Writer methodCallWriter, String callerClassName, String callerMethodName, String callerMethodArgs, JavaCGCallTypeEnum methodCallType, String calleeClassName, String calleeMethodName, String calleeMethodArgs) throws IOException {
        if (JavaCGUtil.checkSkipClass(callerClassName, this.javaCGConfInfo.getNeedHandlePackageSet()) || JavaCGUtil.checkSkipClass(calleeClassName, this.javaCGConfInfo.getNeedHandlePackageSet())) {
            return;
        }
        String callerClassJarNum = this.classAndJarNum.getJarNum(callerClassName);
        String calleeClassJarNum = this.classAndJarNum.getJarNum(calleeClassName);
        MethodCall methodCall = new MethodCall(this.callIdCounter.addAndGet(), callerClassName, callerMethodName, callerMethodArgs, methodCallType, calleeClassName, calleeMethodName, calleeMethodArgs, 0, null, null, null);
        JavaCGFileUtil.write2FileWithTab(methodCallWriter, methodCall.genCallContent(callerClassJarNum, calleeClassJarNum));
    }

    public void setJavaCGConfInfo(JavaCGConfInfo javaCGConfInfo) {
        this.javaCGConfInfo = javaCGConfInfo;
    }

    public void setCallIdCounter(JavaCGCounter callIdCounter) {
        this.callIdCounter = callIdCounter;
    }

    public void setInterfaceMethodWithArgsMap(Map<String, List<MethodAndArgs>> interfaceMethodWithArgsMap) {
        this.interfaceMethodWithArgsMap = interfaceMethodWithArgsMap;
    }

    public void setChildrenClassMap(Map<String, List<String>> childrenClassMap) {
        this.childrenClassMap = childrenClassMap;
    }

    public void setInterfaceExtendsMethodInfoMap(Map<String, InterfaceExtendsMethodInfo> interfaceExtendsMethodInfoMap) {
        this.interfaceExtendsMethodInfoMap = interfaceExtendsMethodInfoMap;
    }

    public void setChildrenInterfaceMap(Map<String, List<String>> childrenInterfaceMap) {
        this.childrenInterfaceMap = childrenInterfaceMap;
    }

    public void setClassImplementsMethodInfoMap(Map<String, ClassImplementsMethodInfo> classImplementsMethodInfoMap) {
        this.classImplementsMethodInfoMap = classImplementsMethodInfoMap;
    }

    public void setClassExtendsMethodInfoMap(Map<String, ClassExtendsMethodInfo> classExtendsMethodInfoMap) {
        this.classExtendsMethodInfoMap = classExtendsMethodInfoMap;
    }

    public void setClassAndJarNum(ClassAndJarNum classAndJarNum) {
        this.classAndJarNum = classAndJarNum;
    }
}

