/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.handler;

import com.adrninistrator.javacg.common.JavaCGCommonNameConstants;
import com.adrninistrator.javacg.common.enums.JavaCGConstantTypeEnum;
import com.adrninistrator.javacg.dto.element.BaseElement;
import com.adrninistrator.javacg.dto.element.constant.ConstElementDouble;
import com.adrninistrator.javacg.dto.element.constant.ConstElementFloat;
import com.adrninistrator.javacg.dto.element.constant.ConstElementInt;
import com.adrninistrator.javacg.dto.element.constant.ConstElementLong;
import com.adrninistrator.javacg.dto.element.constant.ConstElementNull;
import com.adrninistrator.javacg.dto.element.constant.ConstElementString;
import com.adrninistrator.javacg.dto.element.variable.FieldElement;
import com.adrninistrator.javacg.dto.element.variable.JSRElement;
import com.adrninistrator.javacg.dto.element.variable.LocalVariableElement;
import com.adrninistrator.javacg.dto.element.variable.StaticFieldElement;
import com.adrninistrator.javacg.dto.element.variable.StaticFieldMethodCallElement;
import com.adrninistrator.javacg.dto.element.variable.VariableElement;
import com.adrninistrator.javacg.dto.field.FieldPossibleTypes;
import com.adrninistrator.javacg.dto.frame.FieldInformation;
import com.adrninistrator.javacg.dto.frame.JavaCGLocalVariables;
import com.adrninistrator.javacg.dto.frame.JavaCGOperandStack;
import com.adrninistrator.javacg.dto.instruction.BaseInstructionParseResult;
import com.adrninistrator.javacg.dto.instruction.MethodCallParseResult;
import com.adrninistrator.javacg.dto.instruction.RetParseResult;
import com.adrninistrator.javacg.dto.instruction.ReturnParseResult;
import com.adrninistrator.javacg.exceptions.JavaCGRuntimeException;
import com.adrninistrator.javacg.util.JavaCGByteCodeUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.INVOKEDYNAMIC;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.StoreInstruction;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;
import org.apache.commons.lang3.StringUtils;

public class InstructionHandler {
    private final MethodGen mg;
    private final ConstantPoolGen cpg;
    private final LocalVariableTable localVariableTable;
    private JavaCGOperandStack stack;
    private JavaCGLocalVariables locals;
    private FieldInformation nonStaticFieldInfo;
    private FieldInformation staticFieldInfo;
    private boolean recordFieldPossibleTypeFlag;
    private boolean useFieldPossibleTypeFlag;
    private FieldPossibleTypes nonStaticFieldPossibleTypes;

    public InstructionHandler(MethodGen mg, LocalVariableTable localVariableTable, JavaCGOperandStack stack, JavaCGLocalVariables locals, FieldInformation nonStaticFieldInfo, FieldInformation staticFieldInfo) {
        this.mg = mg;
        this.cpg = mg.getConstantPool();
        this.localVariableTable = localVariableTable;
        this.stack = stack;
        this.locals = locals;
        this.nonStaticFieldInfo = nonStaticFieldInfo;
        this.staticFieldInfo = staticFieldInfo;
    }

    private String getTypeString(TypedInstruction typedInstruction) {
        return typedInstruction.getType(this.cpg).toString();
    }

    public BaseInstructionParseResult parse(InstructionHandle ih) {
        Instruction i = ih.getInstruction();
        short opCode = i.getOpcode();
        BaseInstructionParseResult instructionParseResult = null;
        switch (opCode) {
            case 0: {
                break;
            }
            case 1: {
                this.stack.push(new ConstElementNull());
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.stack.push(new ConstElementInt(opCode - 2 - 1));
                break;
            }
            case 9: 
            case 10: {
                this.stack.push(new ConstElementLong(opCode - 9));
                break;
            }
            case 11: {
                this.stack.push(new ConstElementFloat(Float.valueOf(0.0f)));
                break;
            }
            case 12: {
                this.stack.push(new ConstElementFloat(Float.valueOf(1.0f)));
                break;
            }
            case 13: {
                this.stack.push(new ConstElementFloat(Float.valueOf(2.0f)));
                break;
            }
            case 14: {
                this.stack.push(new ConstElementDouble(0.0));
                break;
            }
            case 15: {
                this.stack.push(new ConstElementDouble(1.0));
                break;
            }
            case 16: {
                this.stack.push(new ConstElementInt(((BIPUSH)i).getValue()));
                break;
            }
            case 17: {
                this.stack.push(new ConstElementInt(((SIPUSH)i).getValue()));
                break;
            }
            case 18: 
            case 19: {
                this.handleLDC((LDC)i);
                break;
            }
            case 20: {
                this.handleLDC2W((LDC2_W)i);
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.handleLoad((LoadInstruction)i);
                break;
            }
            case 46: {
                this.handleArrayLoad(JavaCGConstantTypeEnum.CONSTTE_INT);
                break;
            }
            case 47: {
                this.handleArrayLoad(JavaCGConstantTypeEnum.CONSTTE_LONG);
                break;
            }
            case 48: {
                this.handleArrayLoad(JavaCGConstantTypeEnum.CONSTTE_FLOAT);
                break;
            }
            case 49: {
                this.handleArrayLoad(JavaCGConstantTypeEnum.CONSTTE_DOUBLE);
                break;
            }
            case 50: {
                this.handleArrayLoad(null, true);
                break;
            }
            case 51: {
                this.handleArrayLoad(JavaCGConstantTypeEnum.CONSTTE_BYTE);
                break;
            }
            case 52: {
                this.handleArrayLoad(JavaCGConstantTypeEnum.CONSTTE_CHAR);
                break;
            }
            case 53: {
                this.handleArrayLoad(JavaCGConstantTypeEnum.CONSTTE_SHORT);
                break;
            }
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                this.handleStore((StoreInstruction)i, JavaCGConstantTypeEnum.CONSTTE_INT, ih);
                break;
            }
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                this.handleStore((StoreInstruction)i, JavaCGConstantTypeEnum.CONSTTE_LONG, ih);
                break;
            }
            case 56: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                this.handleStore((StoreInstruction)i, JavaCGConstantTypeEnum.CONSTTE_FLOAT, ih);
                break;
            }
            case 57: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                this.handleStore((StoreInstruction)i, JavaCGConstantTypeEnum.CONSTTE_DOUBLE, ih);
                break;
            }
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                this.handleStore((StoreInstruction)i, null, ih);
                break;
            }
            case 79: {
                this.handleArrayStore(JavaCGConstantTypeEnum.CONSTTE_INT);
                break;
            }
            case 80: {
                this.handleArrayStore(JavaCGConstantTypeEnum.CONSTTE_LONG);
                break;
            }
            case 81: {
                this.handleArrayStore(JavaCGConstantTypeEnum.CONSTTE_FLOAT);
                break;
            }
            case 82: {
                this.handleArrayStore(JavaCGConstantTypeEnum.CONSTTE_DOUBLE);
                break;
            }
            case 83: {
                this.handleArrayStore(null, true);
                break;
            }
            case 84: {
                this.handleArrayStore(JavaCGConstantTypeEnum.CONSTTE_BYTE);
                break;
            }
            case 85: {
                this.handleArrayStore(JavaCGConstantTypeEnum.CONSTTE_CHAR);
                break;
            }
            case 86: {
                this.handleArrayStore(JavaCGConstantTypeEnum.CONSTTE_SHORT);
                break;
            }
            case 87: {
                this.stack.pop();
                break;
            }
            case 88: {
                this.handlePOP2();
                break;
            }
            case 89: {
                this.handleDUP();
                break;
            }
            case 90: {
                this.handleDUPX1();
                break;
            }
            case 91: {
                this.handleDUPX2();
                break;
            }
            case 92: {
                this.handleDUP2();
                break;
            }
            case 93: {
                this.handleDUP2X1();
                break;
            }
            case 94: {
                this.handleDUP2X2();
                break;
            }
            case 95: {
                this.handleSWAP();
                break;
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 126: 
            case 128: 
            case 130: {
                this.handleArithmeticOperation2(JavaCGConstantTypeEnum.CONSTTE_INT);
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 127: 
            case 129: 
            case 131: {
                this.handleArithmeticOperation2(JavaCGConstantTypeEnum.CONSTTE_LONG);
                break;
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                this.handleArithmeticOperation2(JavaCGConstantTypeEnum.CONSTTE_FLOAT);
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                this.handleArithmeticOperation2(JavaCGConstantTypeEnum.CONSTTE_DOUBLE);
                break;
            }
            case 116: {
                this.handleArithmeticOperation1(JavaCGConstantTypeEnum.CONSTTE_INT);
                break;
            }
            case 117: {
                this.handleArithmeticOperation1(JavaCGConstantTypeEnum.CONSTTE_LONG);
                break;
            }
            case 118: {
                this.handleArithmeticOperation1(JavaCGConstantTypeEnum.CONSTTE_FLOAT);
                break;
            }
            case 119: {
                this.handleArithmeticOperation1(JavaCGConstantTypeEnum.CONSTTE_DOUBLE);
                break;
            }
            case 120: 
            case 122: 
            case 124: {
                this.handleBitOperator(JavaCGConstantTypeEnum.CONSTTE_INT);
                break;
            }
            case 121: 
            case 123: 
            case 125: {
                this.handleBitOperator(JavaCGConstantTypeEnum.CONSTTE_LONG);
                break;
            }
            case 132: {
                this.handleIinc((IINC)i);
                break;
            }
            case 133: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_INT, JavaCGConstantTypeEnum.CONSTTE_LONG);
                break;
            }
            case 134: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_INT, JavaCGConstantTypeEnum.CONSTTE_FLOAT);
                break;
            }
            case 135: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_INT, JavaCGConstantTypeEnum.CONSTTE_DOUBLE);
                break;
            }
            case 136: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_LONG, JavaCGConstantTypeEnum.CONSTTE_INT);
                break;
            }
            case 137: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_LONG, JavaCGConstantTypeEnum.CONSTTE_FLOAT);
                break;
            }
            case 138: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_LONG, JavaCGConstantTypeEnum.CONSTTE_DOUBLE);
                break;
            }
            case 139: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_FLOAT, JavaCGConstantTypeEnum.CONSTTE_INT);
                break;
            }
            case 140: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_FLOAT, JavaCGConstantTypeEnum.CONSTTE_LONG);
                break;
            }
            case 141: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_FLOAT, JavaCGConstantTypeEnum.CONSTTE_DOUBLE);
                break;
            }
            case 142: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_DOUBLE, JavaCGConstantTypeEnum.CONSTTE_INT);
                break;
            }
            case 143: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_DOUBLE, JavaCGConstantTypeEnum.CONSTTE_LONG);
                break;
            }
            case 144: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_DOUBLE, JavaCGConstantTypeEnum.CONSTTE_FLOAT);
                break;
            }
            case 145: 
            case 146: 
            case 147: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_INT, JavaCGConstantTypeEnum.CONSTTE_INT);
                break;
            }
            case 148: {
                this.handleCompare(JavaCGConstantTypeEnum.CONSTTE_LONG);
                break;
            }
            case 149: 
            case 150: {
                this.handleCompare(JavaCGConstantTypeEnum.CONSTTE_FLOAT);
                break;
            }
            case 151: 
            case 152: {
                this.handleCompare(JavaCGConstantTypeEnum.CONSTTE_DOUBLE);
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                this.handleIf1();
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                this.handleIf2();
                break;
            }
            case 165: 
            case 166: {
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 167: {
                break;
            }
            case 168: {
                this.handleJSR(ih);
                break;
            }
            case 169: {
                instructionParseResult = this.handleRET((RET)i);
                break;
            }
            case 170: 
            case 171: {
                this.stack.pop();
                break;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                instructionParseResult = this.handleReturn();
                break;
            }
            case 177: {
                break;
            }
            case 178: {
                this.handleGETSTATIC((GETSTATIC)i);
                break;
            }
            case 179: {
                this.handlePUTSTATIC((PUTSTATIC)i);
                break;
            }
            case 180: {
                this.handleGETFIELD((GETFIELD)i);
                break;
            }
            case 181: {
                this.handlePUTFIELD((PUTFIELD)i);
                break;
            }
            case 182: {
                instructionParseResult = this.handleMethodInvoke((InvokeInstruction)((INVOKEVIRTUAL)i), true);
                break;
            }
            case 183: {
                instructionParseResult = this.handleMethodInvoke((InvokeInstruction)((INVOKESPECIAL)i), true);
                break;
            }
            case 184: {
                instructionParseResult = this.handleMethodInvoke((InvokeInstruction)((INVOKESTATIC)i), false);
                break;
            }
            case 185: {
                instructionParseResult = this.handleMethodInvoke((InvokeInstruction)((INVOKEINTERFACE)i), true);
                break;
            }
            case 186: {
                instructionParseResult = this.handleMethodInvoke((InvokeInstruction)((INVOKEDYNAMIC)i), false);
                break;
            }
            case 187: {
                this.stack.push(new VariableElement(this.getTypeString((TypedInstruction)((NEW)i))));
                break;
            }
            case 188: {
                this.handleNEWARRAY((NEWARRAY)i);
                break;
            }
            case 189: {
                this.handleANEWARRAY((ANEWARRAY)i);
                break;
            }
            case 190: {
                this.stack.pop();
                this.stack.push(new VariableElement(JavaCGConstantTypeEnum.CONSTTE_INT.getType()));
                break;
            }
            case 191: {
                this.handleATHROW();
                break;
            }
            case 192: {
                this.stack.pop();
                this.stack.push(new VariableElement(this.getTypeString((TypedInstruction)((CHECKCAST)i))));
                break;
            }
            case 193: {
                this.stack.pop();
                this.stack.push(new VariableElement(JavaCGConstantTypeEnum.CONSTTE_INT.getType()));
                break;
            }
            case 194: 
            case 195: {
                this.stack.pop();
                break;
            }
            case 196: {
                break;
            }
            case 197: {
                this.handleMULTIANEWARRAY((MULTIANEWARRAY)i);
                break;
            }
            case 198: 
            case 199: {
                this.stack.pop();
                break;
            }
            case 200: {
                break;
            }
            case 201: {
                this.handleJSR(ih);
                break;
            }
            default: {
                System.err.println("eee \u672a\u5904\u7406\u7684\u6307\u4ee4 " + opCode + " " + i.getClass().getName());
            }
        }
        return instructionParseResult;
    }

    private void handleLDC(LDC ldc) {
        String typeString = this.getTypeString((TypedInstruction)ldc);
        Object value = ldc.getValue(this.cpg);
        if (JavaCGConstantTypeEnum.CONSTTE_INT.getType().equals(typeString)) {
            this.stack.push(new ConstElementInt(value));
        } else if (JavaCGConstantTypeEnum.CONSTTE_FLOAT.getType().equals(typeString)) {
            this.stack.push(new ConstElementFloat(value));
        } else if (JavaCGCommonNameConstants.CLASS_NAME_STRING.equals(typeString)) {
            this.stack.push(new ConstElementString(value));
        } else if (JavaCGCommonNameConstants.CLASS_NAME_CLASS.equals(typeString)) {
            ObjectType objectType = (ObjectType)value;
            this.stack.push(new VariableElement(objectType.getClassName()));
        } else {
            System.err.println("eee LDC \u6682\u4e0d\u652f\u6301\u7684\u60c5\u51b5 " + typeString + " " + value);
        }
    }

    private void handleLDC2W(LDC2_W ldc2W) {
        String typeString = this.getTypeString((TypedInstruction)ldc2W);
        Number value = ldc2W.getValue(this.cpg);
        if (JavaCGConstantTypeEnum.CONSTTE_LONG.getType().equals(typeString)) {
            this.stack.push(new ConstElementLong(value));
        } else if (JavaCGConstantTypeEnum.CONSTTE_DOUBLE.getType().equals(typeString)) {
            this.stack.push(new ConstElementDouble(value));
        } else {
            System.err.println("eee LDC2_W \u6682\u4e0d\u652f\u6301\u7684\u60c5\u51b5 " + typeString + " " + value);
        }
    }

    private void handleLoad(LoadInstruction loadInstruction) {
        int index = loadInstruction.getIndex();
        if (this.locals.size() > index) {
            this.stack.push(this.locals.get(index));
            return;
        }
        throw new JavaCGRuntimeException("\u672c\u5730\u53d8\u91cf\u4e0d\u5b58\u5728 " + index);
    }

    private void handleArrayLoad(JavaCGConstantTypeEnum typeEnum) {
        this.handleArrayLoad(typeEnum.getType(), false);
    }

    private void handleArrayLoad(String elementType, boolean isAaload) {
        String usedElementType;
        BaseElement indexVariable = this.stack.pop();
        BaseElement arrayVariable = this.stack.pop();
        if (!isAaload) {
            usedElementType = elementType;
        } else {
            String arrayType = arrayVariable.getType();
            if (!JavaCGByteCodeUtil.isNullType(arrayType) && !JavaCGByteCodeUtil.isArrayType(arrayType)) {
                throw new JavaCGRuntimeException("\u5f53\u524d\u7c7b\u578b\u4e0d\u662f\u6570\u7ec4 " + arrayType);
            }
            usedElementType = JavaCGByteCodeUtil.removeArrayFlag(arrayType);
        }
        this.stack.push(new VariableElement(usedElementType, true));
        indexVariable.checkTypeString(JavaCGConstantTypeEnum.CONSTTE_INT.getType());
        if (!isAaload) {
            arrayVariable.checkTypeString(JavaCGByteCodeUtil.addArrayFlag(usedElementType));
        }
    }

    private void handleStore(StoreInstruction storeInstruction, JavaCGConstantTypeEnum typeEnum, InstructionHandle ih) {
        int index = storeInstruction.getIndex();
        BaseElement baseElement = this.stack.pop();
        String poppedElementType = baseElement.getType();
        if (typeEnum == null && !JavaCGByteCodeUtil.isNullType(poppedElementType)) {
            this.locals.add(poppedElementType, baseElement, index);
            return;
        }
        LocalVariable localVariable = this.localVariableTable.getLocalVariable(index, ih.getNext().getPosition());
        String actualType = localVariable != null ? Utility.typeSignatureToString((String)localVariable.getSignature(), (boolean)false) : (typeEnum != null ? typeEnum.getType() : poppedElementType);
        this.locals.add(actualType, baseElement, index);
    }

    private void handleArrayStore(JavaCGConstantTypeEnum typeEnum) {
        this.handleArrayStore(typeEnum.getType(), false);
    }

    private void handleArrayStore(String arrayType, boolean isAastore) {
        BaseElement valueVariable = this.stack.pop();
        BaseElement indexVariable = this.stack.pop();
        BaseElement arrayVariable = this.stack.pop();
        indexVariable.checkTypeString(JavaCGConstantTypeEnum.CONSTTE_INT.getType());
        if (!isAastore) {
            valueVariable.checkTypeString(arrayType);
            arrayVariable.checkTypeString(JavaCGByteCodeUtil.addArrayFlag(arrayType));
        }
        if (!arrayVariable.isArrayElement()) {
            System.err.println("\u4e0d\u662f\u6570\u7ec4\u7c7b\u578b " + arrayVariable.getClass().getName());
            return;
        }
        Object indexObj = indexVariable.getValue();
        if (indexObj instanceof Integer) {
            Integer index = (Integer)indexObj;
            arrayVariable.setElement(index, valueVariable);
        }
    }

    private void handlePOP2() {
        BaseElement element = this.stack.pop();
        if (element.getElementSize() == 1) {
            this.stack.pop();
        }
    }

    private void handleDUP() {
        BaseElement element = this.stack.pop();
        this.stack.push(element);
        this.stack.push(element);
    }

    private void handleDUPX1() {
        BaseElement element1 = this.stack.pop();
        BaseElement element2 = this.stack.pop();
        this.stack.push(element1);
        this.stack.push(element2);
        this.stack.push(element1);
    }

    private void handleDUPX2() {
        BaseElement element1 = this.stack.pop();
        BaseElement element2 = this.stack.pop();
        if (element2.getElementSize() == 2) {
            this.stack.push(element1);
            this.stack.push(element2);
            this.stack.push(element1);
            return;
        }
        BaseElement element3 = this.stack.pop();
        this.stack.push(element1);
        this.stack.push(element3);
        this.stack.push(element2);
        this.stack.push(element1);
    }

    private void handleDUP2() {
        BaseElement element1 = this.stack.pop();
        if (element1.getElementSize() == 2) {
            this.stack.push(element1);
            this.stack.push(element1);
            return;
        }
        BaseElement element2 = this.stack.pop();
        this.stack.push(element2);
        this.stack.push(element1);
        this.stack.push(element2);
        this.stack.push(element1);
    }

    private void handleDUP2X1() {
        BaseElement element1 = this.stack.pop();
        BaseElement element2 = this.stack.pop();
        if (element1.getElementSize() == 2) {
            this.stack.push(element1);
            this.stack.push(element2);
            this.stack.push(element1);
            return;
        }
        BaseElement element3 = this.stack.pop();
        this.stack.push(element2);
        this.stack.push(element1);
        this.stack.push(element3);
        this.stack.push(element2);
        this.stack.push(element1);
    }

    private void handleDUP2X2() {
        BaseElement element1 = this.stack.pop();
        BaseElement element2 = this.stack.pop();
        if (element1.getElementSize() == 2) {
            if (element2.getElementSize() == 2) {
                this.stack.push(element1);
                this.stack.push(element2);
                this.stack.push(element1);
                return;
            }
            BaseElement element3 = this.stack.pop();
            this.stack.push(element1);
            this.stack.push(element3);
            this.stack.push(element2);
            this.stack.push(element1);
            return;
        }
        BaseElement element3 = this.stack.pop();
        if (element3.getElementSize() == 2) {
            this.stack.push(element2);
            this.stack.push(element1);
            this.stack.push(element3);
            this.stack.push(element2);
            this.stack.push(element1);
            return;
        }
        BaseElement element4 = this.stack.pop();
        this.stack.push(element2);
        this.stack.push(element1);
        this.stack.push(element4);
        this.stack.push(element3);
        this.stack.push(element2);
        this.stack.push(element1);
    }

    private void handleSWAP() {
        BaseElement element1 = this.stack.pop();
        BaseElement element2 = this.stack.pop();
        this.stack.push(element1);
        this.stack.push(element2);
    }

    private void handleArithmeticOperation2(JavaCGConstantTypeEnum constantTypeEnum) {
        BaseElement value2 = this.stack.pop();
        BaseElement value1 = this.stack.pop();
        this.stack.push(new VariableElement(constantTypeEnum.getType()));
        value2.checkTypeString(constantTypeEnum.getType());
        value1.checkTypeString(constantTypeEnum.getType());
    }

    private void handleArithmeticOperation1(JavaCGConstantTypeEnum constantTypeEnum) {
        BaseElement value = this.stack.pop();
        this.stack.push(new VariableElement(constantTypeEnum.getType()));
        value.checkTypeString(constantTypeEnum.getType());
    }

    private void handleBitOperator(JavaCGConstantTypeEnum constantTypeEnum) {
        BaseElement value2 = this.stack.pop();
        BaseElement value1 = this.stack.pop();
        this.stack.push(new VariableElement(constantTypeEnum.getType()));
        value2.checkTypeString(JavaCGConstantTypeEnum.CONSTTE_INT.getType());
        value1.checkTypeString(constantTypeEnum.getType());
    }

    private void handleIinc(IINC iinc) {
        this.locals.setValue2Null(iinc.getIndex());
    }

    private void handleTypeConversion(JavaCGConstantTypeEnum oldTypeEnum, JavaCGConstantTypeEnum newTypeEnum) {
        BaseElement value = this.stack.pop();
        this.stack.push(new VariableElement(newTypeEnum.getType()));
        value.checkTypeString(oldTypeEnum.getType());
    }

    private void handleCompare(JavaCGConstantTypeEnum constantTypeEnum) {
        BaseElement value2 = this.stack.pop();
        BaseElement value1 = this.stack.pop();
        this.stack.push(new VariableElement(JavaCGConstantTypeEnum.CONSTTE_INT.getType()));
        value2.checkTypeString(constantTypeEnum.getType());
        value1.checkTypeString(constantTypeEnum.getType());
    }

    private void handleIf1() {
        BaseElement value = this.stack.pop();
        value.checkTypeString(JavaCGConstantTypeEnum.CONSTTE_INT.getType());
    }

    private void handleIf2() {
        BaseElement value2 = this.stack.pop();
        BaseElement value1 = this.stack.pop();
        value2.checkTypeString(JavaCGConstantTypeEnum.CONSTTE_INT.getType());
        value1.checkTypeString(JavaCGConstantTypeEnum.CONSTTE_INT.getType());
    }

    private void handleJSR(InstructionHandle ih) {
        this.stack.push(new JSRElement(ih.getNext()));
    }

    private RetParseResult handleRET(RET ret) {
        LocalVariableElement localVariableElement = this.locals.get(ret.getIndex());
        if (!"0jsr".equals(localVariableElement.getType()) || !(localVariableElement.getValue() instanceof InstructionHandle)) {
            throw new JavaCGRuntimeException("ret\u6307\u4ee4\u5bf9\u5e94\u7684\u672c\u5730\u53d8\u91cf\u975e\u6cd5 " + localVariableElement);
        }
        InstructionHandle jsrNextIh = (InstructionHandle)localVariableElement.getValue();
        return new RetParseResult(jsrNextIh);
    }

    private ReturnParseResult handleReturn() {
        BaseElement baseElement = this.stack.pop();
        return new ReturnParseResult(baseElement);
    }

    private void handleGETSTATIC(GETSTATIC getstatic) {
        String fieldName = getstatic.getFieldName(this.cpg);
        ObjectType classType = getstatic.getLoadClassType(this.cpg);
        FieldElement fieldElement = this.staticFieldInfo.getStatic(classType.getClassName(), fieldName);
        if (fieldElement == null) {
            String type = getstatic.getFieldType(this.cpg).toString();
            fieldElement = new StaticFieldElement(type, false, null, fieldName, classType.getClassName());
        }
        this.stack.push(fieldElement);
    }

    private void handlePUTSTATIC(PUTSTATIC putstatic) {
        String fieldName = putstatic.getFieldName(this.cpg);
        ObjectType classType = putstatic.getLoadClassType(this.cpg);
        BaseElement value = this.stack.pop();
        StaticFieldElement staticFieldElement = new StaticFieldElement(value.getType(), value.isArrayElement(), value.getValue(), fieldName, classType.getClassName());
        if (value.isArrayElement()) {
            staticFieldElement.setArrayValueMap(value.getArrayValueMap());
        }
        this.staticFieldInfo.putStatic(classType.getClassName(), fieldName, staticFieldElement);
    }

    private void handleGETFIELD(GETFIELD getfield) {
        List<String> possibleTypeList;
        LocalVariableElement localVariableElement;
        String fieldName = getfield.getFieldName(this.cpg);
        BaseElement object = this.stack.pop();
        FieldElement fieldElement = null;
        if (object instanceof LocalVariableElement && (localVariableElement = (LocalVariableElement)object).isThis() && (fieldElement = this.nonStaticFieldInfo.get(fieldName)) != null) {
            this.stack.push(fieldElement);
            return;
        }
        if (this.useFieldPossibleTypeFlag && !JavaCGUtil.isCollectionEmpty(possibleTypeList = this.nonStaticFieldPossibleTypes.getPossibleTypeList(fieldName))) {
            if (possibleTypeList.size() == 1) {
                String type = possibleTypeList.get(0);
                fieldElement = new FieldElement(type, false, null, fieldName);
            } else {
                System.err.println(this.mg.getClassName() + " \u7c7b\u7684\u6784\u9020\u51fd\u6570\u89e3\u6790\u540e " + fieldName + " \u975e\u9759\u6001\u5b57\u6bb5\u53ef\u80fd\u7684\u7c7b\u578b\u6570\u91cf\u5927\u4e8e1 " + StringUtils.join(possibleTypeList, (String)" "));
            }
        }
        if (fieldElement == null) {
            String type = getfield.getFieldType(this.cpg).toString();
            fieldElement = new FieldElement(type, false, null, fieldName);
        }
        this.stack.push(fieldElement);
    }

    private void handlePUTFIELD(PUTFIELD putfield) {
        LocalVariableElement localVariableElement;
        String fieldName = putfield.getFieldName(this.cpg);
        BaseElement value = this.stack.pop();
        BaseElement object = this.stack.pop();
        if (object instanceof LocalVariableElement && (localVariableElement = (LocalVariableElement)object).isThis()) {
            String rawFieldType;
            FieldElement fieldElement = new FieldElement(value.getType(), value.isArrayElement(), value.getValue(), fieldName);
            if (value.isArrayElement()) {
                fieldElement.setArrayValueMap(value.getArrayValueMap());
            }
            this.nonStaticFieldInfo.put(fieldName, fieldElement);
            if (this.recordFieldPossibleTypeFlag && !StringUtils.equals((CharSequence)(rawFieldType = putfield.getFieldType(this.cpg).toString()), (CharSequence)value.getType())) {
                this.nonStaticFieldPossibleTypes.addPossibleType(fieldName, value.getType());
            }
        }
    }

    private MethodCallParseResult handleMethodInvoke(InvokeInstruction invokeInstruction, boolean userObjectReference) {
        Type returnType;
        int argumentNumber = invokeInstruction.getArgumentTypes(this.cpg).length;
        ArrayList<BaseElement> argumentList = new ArrayList<BaseElement>(argumentNumber);
        for (int i = 0; i < argumentNumber; ++i) {
            argumentList.add(0, this.stack.pop());
        }
        BaseElement objectElement = null;
        if (userObjectReference) {
            objectElement = this.stack.pop();
        }
        if (Type.VOID != (returnType = invokeInstruction.getReturnType(this.cpg))) {
            VariableElement variableElement;
            if (objectElement instanceof StaticFieldElement) {
                StaticFieldElement staticFieldElement = (StaticFieldElement)objectElement;
                variableElement = new StaticFieldMethodCallElement(returnType.toString(), returnType instanceof ArrayType, staticFieldElement.getClassName(), staticFieldElement.getFieldName(), invokeInstruction.getMethodName(this.cpg));
            } else {
                variableElement = new VariableElement(returnType.toString());
            }
            this.stack.push(variableElement);
        }
        return new MethodCallParseResult(objectElement, argumentList);
    }

    private void handleNEWARRAY(NEWARRAY newarray) {
        BaseElement countVariable = this.stack.pop();
        VariableElement arrayElement = new VariableElement(newarray.getType().toString(), true);
        this.stack.push(arrayElement);
        countVariable.checkTypeString(JavaCGConstantTypeEnum.CONSTTE_INT.getType());
    }

    private void handleANEWARRAY(ANEWARRAY anewarray) {
        BaseElement countVariable = this.stack.pop();
        VariableElement arrayElement = new VariableElement(JavaCGByteCodeUtil.addArrayFlag(this.getTypeString((TypedInstruction)anewarray)), true);
        this.stack.push(arrayElement);
        countVariable.checkTypeString(JavaCGConstantTypeEnum.CONSTTE_INT.getType());
    }

    private void handleATHROW() {
        BaseElement throwableElement = this.stack.pop();
        this.stack.push(throwableElement);
    }

    private void handleMULTIANEWARRAY(MULTIANEWARRAY multianewarray) {
        for (int i = 0; i < multianewarray.getDimensions(); ++i) {
            this.stack.pop();
        }
        VariableElement arrayElement = new VariableElement(this.getTypeString((TypedInstruction)multianewarray), true);
        this.stack.push(arrayElement);
    }

    public void setStack(JavaCGOperandStack stack) {
        this.stack = stack;
    }

    public void setLocals(JavaCGLocalVariables locals) {
        this.locals = locals;
    }

    public void setNonStaticFieldInfo(FieldInformation nonStaticFieldInfo) {
        this.nonStaticFieldInfo = nonStaticFieldInfo;
    }

    public void setStaticFieldInfo(FieldInformation staticFieldInfo) {
        this.staticFieldInfo = staticFieldInfo;
    }

    public void setRecordFieldPossibleTypeFlag(boolean recordFieldPossibleTypeFlag) {
        this.recordFieldPossibleTypeFlag = recordFieldPossibleTypeFlag;
    }

    public void setUseFieldPossibleTypeFlag(boolean useFieldPossibleTypeFlag) {
        this.useFieldPossibleTypeFlag = useFieldPossibleTypeFlag;
    }

    public void setNonStaticFieldPossibleTypes(FieldPossibleTypes nonStaticFieldPossibleTypes) {
        this.nonStaticFieldPossibleTypes = nonStaticFieldPossibleTypes;
    }
}

