/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.handler;

import com.adrninistrator.javacg.common.enums.JavaCGCalleeObjTypeEnum;
import com.adrninistrator.javacg.common.enums.JavaCGConstantTypeEnum;
import com.adrninistrator.javacg.conf.JavaCGConfInfo;
import com.adrninistrator.javacg.dto.branch.BranchStackEntry;
import com.adrninistrator.javacg.dto.call.MethodCallPossibleInfo;
import com.adrninistrator.javacg.dto.element.BaseElement;
import com.adrninistrator.javacg.dto.element.variable.FieldElement;
import com.adrninistrator.javacg.dto.element.variable.LocalVariableElement;
import com.adrninistrator.javacg.dto.element.variable.StaticFieldElement;
import com.adrninistrator.javacg.dto.element.variable.VariableElement;
import com.adrninistrator.javacg.dto.exception.ExceptionTargetInfo;
import com.adrninistrator.javacg.dto.field.FieldPossibleTypes;
import com.adrninistrator.javacg.dto.frame.FieldInformation;
import com.adrninistrator.javacg.dto.frame.FrameSnapshotEntry;
import com.adrninistrator.javacg.dto.frame.FrameSnapshotsOfIhs;
import com.adrninistrator.javacg.dto.frame.InstructionStep;
import com.adrninistrator.javacg.dto.frame.JavaCGLocalVariables;
import com.adrninistrator.javacg.dto.frame.JavaCGOperandStack;
import com.adrninistrator.javacg.dto.instruction.BaseInstructionParseResult;
import com.adrninistrator.javacg.dto.instruction.MethodCallParseResult;
import com.adrninistrator.javacg.dto.instruction.RetParseResult;
import com.adrninistrator.javacg.dto.instruction.ReturnParseResult;
import com.adrninistrator.javacg.dto.stack.ListAsStack;
import com.adrninistrator.javacg.handler.AbstractMethodHandler;
import com.adrninistrator.javacg.handler.InstructionHandler;
import com.adrninistrator.javacg.util.JavaCGElementUtil;
import com.adrninistrator.javacg.util.JavaCGInstructionUtil;
import com.adrninistrator.javacg.util.JavaCGLogUtil;
import com.adrninistrator.javacg.util.JavaCGMethodUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.Type;

public class MethodHandler4TypeAndValue
extends AbstractMethodHandler {
    private InstructionHandler instructionHandler;
    private JavaCGOperandStack stack;
    private JavaCGLocalVariables locals;
    private FieldInformation nonStaticFieldInfo;
    private FieldInformation staticFieldInfo;
    private Set<Integer> jumpTargetIhPositionSet;
    private ListAsStack<BranchStackEntry> branchStack;
    private Map<Integer, FrameSnapshotEntry> frameSnapshotMap4Branch;
    private FrameSnapshotsOfIhs frameSnapshotsOfIhs4JumpTargets;
    private Map<Integer, List<ExceptionTargetInfo>> exceptionTargetMap;
    private FrameSnapshotsOfIhs frameSnapshotsOfIhs4Exceptions;
    private InstructionStep instructionStep;
    private Map<Integer, InstructionStep> instructionStepMap4Branch;
    private Map<Integer, MethodCallPossibleInfo> methodCallPossibleInfoMap;
    private List<BaseElement> returnPossibleInfoList;
    private boolean recordReturnPossibleInfoFlag;
    private boolean recordFieldPossibleTypeFlag;
    private boolean useFieldPossibleTypeFlag;
    private FieldPossibleTypes nonStaticFieldPossibleTypes;

    public MethodHandler4TypeAndValue(MethodGen mg, JavaClass javaClass, JavaCGConfInfo javaCGConfInfo) {
        super(mg, javaClass, javaCGConfInfo);
    }

    @Override
    protected boolean preHandleMethod() {
        this.ih = JavaCGInstructionUtil.getFirstInstructionHandle(this.mg);
        if (this.ih == null) {
            return false;
        }
        this.recordJumpTargetInstructionHandle();
        this.recordExceptionJumpInfo();
        return true;
    }

    private void recordJumpTargetInstructionHandle() {
        for (InstructionHandle tempIh : this.mg.getInstructionList()) {
            Instruction instruction = tempIh.getInstruction();
            if (instruction instanceof BranchInstruction) {
                BranchInstruction branchInstruction = (BranchInstruction)instruction;
                this.addJumpTargetIhPosition2Set(branchInstruction.getTarget().getPosition());
            }
            if (!JavaCGInstructionUtil.isSwitchInstruction(instruction.getOpcode())) continue;
            Select switchInstruction = (Select)instruction;
            for (InstructionHandle target : switchInstruction.getTargets()) {
                this.addJumpTargetIhPosition2Set(target.getPosition());
            }
        }
        if (this.jumpTargetIhPositionSet != null) {
            this.frameSnapshotsOfIhs4JumpTargets = new FrameSnapshotsOfIhs();
        }
    }

    private void addJumpTargetIhPosition2Set(int position) {
        if (this.jumpTargetIhPositionSet == null) {
            this.jumpTargetIhPositionSet = new HashSet<Integer>();
        }
        this.jumpTargetIhPositionSet.add(position);
    }

    private void recordExceptionJumpInfo() {
        int exceptionTableToPosition;
        CodeExceptionGen[] codeExceptionGens = this.mg.getExceptionHandlers();
        if (codeExceptionGens.length <= 0) {
            return;
        }
        HashMap<Integer, Integer> exceptionTableToMap = new HashMap<Integer, Integer>();
        this.exceptionTargetMap = new HashMap<Integer, List<ExceptionTargetInfo>>();
        for (CodeExceptionGen codeExceptionGen : codeExceptionGens) {
            exceptionTableToPosition = codeExceptionGen.getEndPC().getPosition();
            if (exceptionTableToPosition != codeExceptionGen.getHandlerPC().getPosition()) continue;
            int exceptionTableToPrevPosition = codeExceptionGen.getEndPC().getPrev().getPosition();
            if (JavaCGLogUtil.isDebugPrintFlag()) {
                JavaCGLogUtil.debugPrint("### \u4fee\u6539\u4f7f\u7528\u7684Exception table\u7684to\u7684\u4f4d\u7f6e " + exceptionTableToPosition + " " + exceptionTableToPrevPosition);
            }
            exceptionTableToMap.put(exceptionTableToPosition, exceptionTableToPrevPosition);
        }
        for (CodeExceptionGen codeExceptionGen : codeExceptionGens) {
            exceptionTableToPosition = codeExceptionGen.getEndPC().getPosition();
            Integer actualExceptionTableToPosition = (Integer)exceptionTableToMap.get(exceptionTableToPosition);
            int usedExceptionTableToPosition = actualExceptionTableToPosition != null ? actualExceptionTableToPosition : exceptionTableToPosition;
            List exceptionTargetList = this.exceptionTargetMap.computeIfAbsent(usedExceptionTableToPosition, k -> new ArrayList());
            ObjectType catchType = codeExceptionGen.getCatchType();
            String exceptionType = catchType != null ? catchType.getClassName() : JavaCGConstantTypeEnum.CONSTTE_NULL.getType();
            ExceptionTargetInfo exceptionTargetInfo = new ExceptionTargetInfo(codeExceptionGen.getHandlerPC(), exceptionType);
            exceptionTargetList.add(exceptionTargetInfo);
        }
        this.frameSnapshotsOfIhs4Exceptions = new FrameSnapshotsOfIhs();
    }

    private boolean checkExceptionTo(int position) {
        if (this.exceptionTargetMap == null) {
            return false;
        }
        return this.exceptionTargetMap.get(position) != null;
    }

    @Override
    protected boolean doHandleMethod() {
        if (JavaCGLogUtil.isDebugPrintFlag()) {
            JavaCGLogUtil.debugPrint(this.recordFieldPossibleTypeFlag ? "@@@ \u9884\u5904\u7406\u6784\u9020\u51fd\u6570 " : "@@@ \u5904\u7406\u65b9\u6cd5 " + JavaCGMethodUtil.formatFullMethod(this.javaClass.getClassName(), this.mg.getName(), this.mg.getArgumentTypes()));
        }
        this.initObjects();
        this.handleAllInstruction();
        this.handleExceptionCatchInstructions();
        return true;
    }

    private void initObjects() {
        LocalVariableTable localVariableTable = this.mg.getLocalVariableTable(this.cpg);
        this.stack = new JavaCGOperandStack(this.mg.getMaxStack());
        this.locals = new JavaCGLocalVariables(this.mg);
        this.nonStaticFieldInfo = new FieldInformation();
        this.staticFieldInfo = new FieldInformation();
        this.frameSnapshotMap4Branch = new HashMap<Integer, FrameSnapshotEntry>();
        if (JavaCGLogUtil.checkDebugFlag()) {
            this.instructionStep = new InstructionStep();
            this.instructionStepMap4Branch = new HashMap<Integer, InstructionStep>();
        }
        this.instructionHandler = new InstructionHandler(this.mg, localVariableTable, this.stack, this.locals, this.nonStaticFieldInfo, this.staticFieldInfo);
        this.instructionHandler.setRecordFieldPossibleTypeFlag(this.recordFieldPossibleTypeFlag);
        this.instructionHandler.setUseFieldPossibleTypeFlag(this.useFieldPossibleTypeFlag);
        this.instructionHandler.setNonStaticFieldPossibleTypes(this.nonStaticFieldPossibleTypes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleAllInstruction() {
        while (true) {
            BaseInstructionParseResult instructionParseResult;
            int position = this.ih.getPosition();
            if (JavaCGLogUtil.isDebugPrintFlag()) {
                JavaCGLogUtil.debugPrint("### \u5904\u7406\u6307\u4ee4 " + JavaCGInstructionUtil.getInstructionHandlePrintInfo(this.ih) + " (" + this.getSourceLine() + ")");
            }
            if (this.skipJumpTargetInstructionHandle()) {
                if (!this.handleBranchStackTopEntry()) continue;
                return;
            }
            if (this.instructionStep != null) {
                this.instructionStep.add(JavaCGInstructionUtil.getInstructionHandlePrintInfo(this.ih), this.getSourceLine());
            }
            if (this.checkExceptionTo(position)) {
                if (JavaCGLogUtil.isDebugPrintFlag()) {
                    JavaCGLogUtil.debugPrint("### \u5f02\u5e38\u5904\u7406\uff0c\u6dfb\u52a0\u4fe1\u606f\u5feb\u7167 " + JavaCGInstructionUtil.getInstructionHandlePrintInfo(this.ih));
                }
                this.frameSnapshotsOfIhs4Exceptions.addSnapshot(position, this.stack, this.locals, this.nonStaticFieldInfo, this.staticFieldInfo);
            }
            if (this.handleInstructionsByType(instructionParseResult = this.instructionHandler.parse(this.ih))) return;
        }
    }

    private boolean handleInstructionsByType(BaseInstructionParseResult instructionParseResult) {
        short opCode = this.ih.getInstruction().getOpcode();
        if (JavaCGInstructionUtil.isIfInstruction(opCode)) {
            return this.handleIfInstruction();
        }
        if (JavaCGInstructionUtil.isSwitchInstruction(opCode)) {
            return this.handleSwitchInstruction();
        }
        if (JavaCGInstructionUtil.isGotoInstruction(opCode)) {
            this.handleGotoInstruction();
            return false;
        }
        if (JavaCGInstructionUtil.isExitInstruction(opCode)) {
            if (this.recordReturnPossibleInfoFlag && JavaCGInstructionUtil.isReturnWithValueInstruction(opCode)) {
                this.handleReturnInstruction((ReturnParseResult)instructionParseResult);
            }
            return this.handleExitInstruction();
        }
        if (JavaCGInstructionUtil.isJsrInstruction(opCode)) {
            this.handleJsrInstruction();
            return false;
        }
        if (JavaCGInstructionUtil.isRetInstruction(opCode)) {
            this.handleRetInstruction((RetParseResult)instructionParseResult);
            return false;
        }
        if (this.parseMethodCallTypeValueFlag && JavaCGInstructionUtil.isMethodInvokeInstructionExcludeDynamic(opCode)) {
            this.handleInvokeInstructionExcludeDynamic((MethodCallParseResult)instructionParseResult);
        }
        this.setIh2Next(this.ih.getNext(), "next");
        return false;
    }

    private void handleExceptionCatchInstructions() {
        if (this.exceptionTargetMap == null) {
            return;
        }
        ArrayList<Integer> exceptionToPositionList = new ArrayList<Integer>(this.exceptionTargetMap.keySet());
        Collections.sort(exceptionToPositionList);
        Iterator iterator = exceptionToPositionList.iterator();
        while (iterator.hasNext()) {
            List<FrameSnapshotEntry> exceptionToFrameSnapshotList;
            List<ExceptionTargetInfo> exceptionTargetList;
            int exceptionToPosition = (Integer)iterator.next();
            if (JavaCGLogUtil.isDebugPrintFlag()) {
                JavaCGLogUtil.debugPrint("### \u5904\u7406\u5f02\u5e38\u5904\u7406\u6307\u4ee4 [" + exceptionToPosition + "]");
            }
            if ((exceptionTargetList = this.exceptionTargetMap.get(exceptionToPosition)) == null || (exceptionToFrameSnapshotList = this.frameSnapshotsOfIhs4Exceptions.get(exceptionToPosition)) == null) continue;
            for (ExceptionTargetInfo exceptionTargetInfo : exceptionTargetList) {
                for (int i = 0; i < exceptionToFrameSnapshotList.size(); ++i) {
                    FrameSnapshotEntry exceptionToFrameSnapshot = exceptionToFrameSnapshotList.get(i);
                    this.ih = exceptionTargetInfo.getTarget();
                    this.resetFrameInfo(exceptionToFrameSnapshot, exceptionTargetInfo.getExceptionType());
                    if (this.instructionStep != null) {
                        this.instructionStep.clear();
                    }
                    this.handleAllInstruction();
                }
            }
        }
    }

    private void resetFrameInfo(FrameSnapshotEntry frameSnapshotEntry, String exceptionType) {
        if (exceptionType != null) {
            this.stack.clear();
            this.stack.push(new VariableElement(exceptionType));
        } else {
            this.stack = frameSnapshotEntry.copyStackSnapshot();
        }
        this.instructionHandler.setStack(this.stack);
        this.locals = frameSnapshotEntry.copyLocalsSnapshot();
        this.instructionHandler.setLocals(this.locals);
        this.nonStaticFieldInfo = frameSnapshotEntry.copyNonStaticFieldInfo();
        this.instructionHandler.setNonStaticFieldInfo(this.nonStaticFieldInfo);
        this.staticFieldInfo = frameSnapshotEntry.copyStaticFieldInfo();
        this.instructionHandler.setStaticFieldInfo(this.staticFieldInfo);
    }

    private void setIh2Next(InstructionHandle nextIh, String type) {
        this.ih = nextIh;
        if (JavaCGLogUtil.isDebugPrintFlag()) {
            JavaCGLogUtil.debugPrint(type + " \u4e0b\u4e00\u6761\u5904\u7406\u7684\u6307\u4ee4 " + this.ih.getPosition());
        }
    }

    private boolean skipJumpTargetInstructionHandle() {
        int position = this.ih.getPosition();
        if (this.jumpTargetIhPositionSet == null || !this.jumpTargetIhPositionSet.contains(position)) {
            return false;
        }
        if (!this.frameSnapshotsOfIhs4JumpTargets.addSnapshot(position, this.stack, this.locals, this.nonStaticFieldInfo, this.staticFieldInfo)) {
            if (JavaCGLogUtil.isDebugPrintFlag()) {
                JavaCGLogUtil.debugPrint("\u8df3\u8f6c\u76ee\u6807\u6307\u4ee4[\u8df3\u8fc7]\u5904\u7406 " + position);
            }
            return true;
        }
        if (JavaCGLogUtil.isDebugPrintFlag()) {
            JavaCGLogUtil.debugPrint("\u8df3\u8f6c\u76ee\u6807\u6307\u4ee4[\u9700\u8981]\u5904\u7406 " + position);
        }
        return false;
    }

    private boolean handleIfInstruction() {
        IfInstruction ifInstruction = (IfInstruction)this.ih.getInstruction();
        BranchStackEntry branchStackEntry = new BranchStackEntry(this.ih, 2);
        branchStackEntry.addTargetIh(this.ih.getNext());
        branchStackEntry.addTargetIh(ifInstruction.getTarget());
        return this.handleBranchInstruction(branchStackEntry);
    }

    private boolean handleSwitchInstruction() {
        Select switchInstruction = (Select)this.ih.getInstruction();
        InstructionHandle[] targets = switchInstruction.getTargets();
        BranchStackEntry branchStackEntry = new BranchStackEntry(this.ih, targets.length + 1);
        if (targets.length > 0) {
            for (InstructionHandle target : targets) {
                branchStackEntry.addTargetIh(target);
            }
        }
        branchStackEntry.addTargetIh(switchInstruction.getTarget());
        return this.handleBranchInstruction(branchStackEntry);
    }

    private boolean handleBranchInstruction(BranchStackEntry branchStackEntry) {
        if (this.branchStack == null) {
            this.branchStack = new ListAsStack();
        }
        int ihPosition = branchStackEntry.getBranchIh().getPosition();
        for (int i = 0; i <= this.branchStack.getHead(); ++i) {
            BranchStackEntry tmpBranchStackEntry = this.branchStack.getElement(i);
            if (ihPosition != tmpBranchStackEntry.getBranchIh().getPosition()) continue;
            return this.handleBranchStackTopEntry();
        }
        this.branchStack.push(branchStackEntry);
        Integer branchStackIndex = this.branchStack.getHead();
        this.setIh2Next(branchStackEntry.getTargetIhList().get(0), "branch");
        FrameSnapshotEntry frameSnapshotEntry = new FrameSnapshotEntry(this.stack.copy(), this.locals.copy(), this.nonStaticFieldInfo.copy(), this.staticFieldInfo.copy());
        this.frameSnapshotMap4Branch.put(branchStackIndex, frameSnapshotEntry);
        if (this.instructionStep != null) {
            this.instructionStepMap4Branch.put(branchStackIndex, this.instructionStep.copy());
        }
        return false;
    }

    private void handleGotoInstruction() {
        GotoInstruction gotoInstruction = (GotoInstruction)this.ih.getInstruction();
        this.setIh2Next(gotoInstruction.getTarget(), "goto");
    }

    private boolean handleExitInstruction() {
        if (this.branchStack == null) {
            return true;
        }
        return this.handleBranchStackTopEntry();
    }

    private void handleJsrInstruction() {
        JsrInstruction jsrInstruction = (JsrInstruction)this.ih.getInstruction();
        this.setIh2Next(jsrInstruction.getTarget(), "jsr");
    }

    private void handleRetInstruction(RetParseResult retParseResult) {
        this.setIh2Next(retParseResult.getJsrNextIh(), "jsr_next");
    }

    private boolean handleBranchStackTopEntry() {
        if (this.branchStack == null || this.branchStack.isEmpty()) {
            return true;
        }
        BranchStackEntry branchStackEntry = this.branchStack.peek();
        int branchPosition = branchStackEntry.getBranchIh().getPosition();
        if (JavaCGLogUtil.isDebugPrintFlag()) {
            JavaCGLogUtil.debugPrint("\u5904\u7406\u7528\u4e8e\u904d\u5386\u5206\u652f\u6307\u4ee4\u7684\u6808\u4e2d\u6808\u9876\u5143\u7d20 " + branchPosition);
        }
        Integer branchStackIndex = this.branchStack.getHead();
        int targetIhIndex = branchStackEntry.getTargetIhIndex();
        List<InstructionHandle> targetIhList = branchStackEntry.getTargetIhList();
        if (++targetIhIndex >= targetIhList.size()) {
            this.frameSnapshotMap4Branch.remove(branchStackIndex);
            if (this.instructionStep != null) {
                this.instructionStepMap4Branch.remove(branchStackIndex);
            }
            this.branchStack.removeTop();
            if (this.branchStack.isEmpty()) {
                return true;
            }
            return this.handleBranchStackTopEntry();
        }
        this.setIh2Next(branchStackEntry.getTargetIhList().get(targetIhIndex), "branch_next");
        FrameSnapshotEntry frameSnapshot4Branch = this.frameSnapshotMap4Branch.get(branchStackIndex);
        this.resetFrameInfo(frameSnapshot4Branch, null);
        if (this.instructionStep != null) {
            this.instructionStep = this.instructionStepMap4Branch.get(branchStackIndex).copy();
        }
        branchStackEntry.setTargetIhIndex(targetIhIndex);
        return false;
    }

    private void handleInvokeInstructionExcludeDynamic(MethodCallParseResult methodCallParseResult) {
        InvokeInstruction invokeInstruction = (InvokeInstruction)this.ih.getInstruction();
        if (this.methodCallPossibleInfoMap == null) {
            this.methodCallPossibleInfoMap = new HashMap<Integer, MethodCallPossibleInfo>(10);
        }
        MethodCallPossibleInfo methodCallPossibleInfo = this.methodCallPossibleInfoMap.computeIfAbsent(this.ih.getPosition(), k -> new MethodCallPossibleInfo());
        String callerMethodName = this.mg.getName();
        String calleeClassName = invokeInstruction.getReferenceType(this.cpg).toString();
        String calleeMethodName = invokeInstruction.getMethodName(this.cpg);
        Type[] argTypes = invokeInstruction.getArgumentTypes(this.cpg);
        if (JavaCGLogUtil.isDebugPrintFlag()) {
            JavaCGLogUtil.debugPrint("\u88ab\u8c03\u7528\u65b9\u6cd5: " + JavaCGMethodUtil.formatFullMethod(calleeClassName, calleeMethodName, argTypes));
        }
        BaseElement objectElement = methodCallParseResult.getObjectElement();
        methodCallPossibleInfo.setObjTypeEnum(this.getCalleeObjTypeEnum(objectElement));
        if (!(JavaCGUtil.isInitMethod(callerMethodName) && JavaCGUtil.isObjectClass(calleeClassName) && JavaCGUtil.isInitMethod(calleeMethodName))) {
            methodCallPossibleInfo.addPossibleInfo4Object(objectElement, calleeClassName);
        }
        List<BaseElement> argumentList = methodCallParseResult.getArgumentList();
        for (int i = 0; i < argumentList.size(); ++i) {
            BaseElement baseElement = argumentList.get(i);
            methodCallPossibleInfo.addPossibleInfo4Args(i, baseElement, argTypes[i].toString());
        }
    }

    private JavaCGCalleeObjTypeEnum getCalleeObjTypeEnum(BaseElement objectElement) {
        LocalVariableElement objLocalVariableElement;
        if (objectElement instanceof StaticFieldElement) {
            return JavaCGCalleeObjTypeEnum.COTE_STATIC_FIELD;
        }
        if (objectElement instanceof FieldElement) {
            return JavaCGCalleeObjTypeEnum.COTE_FIELD;
        }
        if (objectElement instanceof LocalVariableElement && (objLocalVariableElement = (LocalVariableElement)objectElement).isThis()) {
            return JavaCGCalleeObjTypeEnum.COTE_THIS;
        }
        if (objectElement instanceof VariableElement) {
            return JavaCGCalleeObjTypeEnum.COTE_VARIABLE;
        }
        return null;
    }

    private void handleReturnInstruction(ReturnParseResult returnParseResult) {
        BaseElement returnInfo = returnParseResult.getReturnInfo();
        if (this.returnPossibleInfoList == null) {
            this.returnPossibleInfoList = new ArrayList<BaseElement>();
            this.returnPossibleInfoList.add(returnInfo);
            return;
        }
        for (BaseElement baseElement : this.returnPossibleInfoList) {
            if (!JavaCGElementUtil.compare(baseElement, returnInfo)) continue;
            return;
        }
        this.returnPossibleInfoList.add(returnInfo);
    }

    public MethodCallPossibleInfo getMethodCallPossibleInfo(int position) {
        if (this.methodCallPossibleInfoMap == null) {
            return null;
        }
        return this.methodCallPossibleInfoMap.get(position);
    }

    public List<String> getReturnPossibleTypeList() {
        if (this.returnPossibleInfoList == null) {
            return null;
        }
        ArrayList<String> returnPossibleTypeList = new ArrayList<String>(this.returnPossibleInfoList.size());
        for (BaseElement baseElement : this.returnPossibleInfoList) {
            String type = baseElement.getType();
            if (returnPossibleTypeList.contains(type)) continue;
            returnPossibleTypeList.add(type);
        }
        return returnPossibleTypeList;
    }

    public void setRecordReturnPossibleInfoFlag(boolean recordReturnPossibleInfoFlag) {
        this.recordReturnPossibleInfoFlag = recordReturnPossibleInfoFlag;
    }

    public void setRecordFieldPossibleTypeFlag(boolean recordFieldPossibleTypeFlag) {
        this.recordFieldPossibleTypeFlag = recordFieldPossibleTypeFlag;
    }

    public void setUseFieldPossibleTypeFlag(boolean useFieldPossibleTypeFlag) {
        this.useFieldPossibleTypeFlag = useFieldPossibleTypeFlag;
    }

    public void setNonStaticFieldPossibleTypes(FieldPossibleTypes nonStaticFieldPossibleTypes) {
        this.nonStaticFieldPossibleTypes = nonStaticFieldPossibleTypes;
    }
}

