/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.parser;

import com.adrninistrator.javacg.conf.JavaCGConfInfo;
import com.adrninistrator.javacg.dto.jar.JarInfo;
import com.adrninistrator.javacg.util.JavaCGFileUtil;
import com.adrninistrator.javacg.util.JavaCGLogUtil;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;

public abstract class AbstractJarEntryParser {
    protected String simpleClassName = this.getClass().getSimpleName();
    protected JavaCGConfInfo javaCGConfInfo;
    protected Map<String, JarInfo> jarInfoMap;
    protected String lastFirstDirName;
    protected JarInfo lastJarInfo;

    protected AbstractJarEntryParser(JavaCGConfInfo javaCGConfInfo, Map<String, JarInfo> jarInfoMap) {
        this.javaCGConfInfo = javaCGConfInfo;
        this.jarInfoMap = jarInfoMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean parse(String jarFilePath) {
        this.init();
        String jarEntryName = null;
        try (JarInputStream jarInputStream = new JarInputStream(new BufferedInputStream(new FileInputStream(jarFilePath), 32768));){
            JarEntry jarEntry;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                if (jarEntry.isDirectory()) continue;
                jarEntryName = jarEntry.getName();
                if (JavaCGLogUtil.isDebugPrintFlag()) {
                    JavaCGLogUtil.debugPrint(this.simpleClassName + " \u5904\u7406\u6587\u4ef6: " + jarEntryName);
                }
                if (!this.handleCurrentJarInfo(jarEntryName)) {
                    boolean bl = false;
                    return bl;
                }
                if (this.handleEntry(jarInputStream, jarEntryName)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.err.println(this.simpleClassName + " \u5904\u7406jar\u5305\u4e2d\u7684\u6587\u4ef6\u51fa\u73b0\u95ee\u9898: " + jarEntryName);
            e.printStackTrace();
            return false;
        }
    }

    protected void init() {
    }

    protected abstract boolean handleEntry(JarInputStream var1, String var2) throws IOException;

    protected boolean tryHandleClassEntry(InputStream inputStream, String jarEntryName) throws IOException {
        if (!JavaCGFileUtil.isClassFile(jarEntryName)) {
            return false;
        }
        JavaClass javaClass = new ClassParser(inputStream, jarEntryName).parse();
        this.handleClassEntry(javaClass, jarEntryName);
        return true;
    }

    protected boolean handleClassEntry(JavaClass javaClass, String jarEntryName) throws IOException {
        return true;
    }

    private boolean handleCurrentJarInfo(String jarEntryName) {
        if (this.jarInfoMap.size() == 1) {
            Iterator<Map.Entry<String, JarInfo>> iterator;
            if (this.lastJarInfo == null && (iterator = this.jarInfoMap.entrySet().iterator()).hasNext()) {
                Map.Entry<String, JarInfo> entry = iterator.next();
                this.lastJarInfo = entry.getValue();
                return true;
            }
            return true;
        }
        int index = jarEntryName.indexOf("/");
        if (index == -1) {
            System.err.println("JarEntry\u540d\u79f0\u4e2d\u4e0d\u5305\u542b/ " + jarEntryName);
            return false;
        }
        String firstDirName = jarEntryName.substring(0, index);
        if (this.lastFirstDirName != null && this.lastFirstDirName.equals(firstDirName)) {
            return true;
        }
        this.lastFirstDirName = firstDirName;
        this.lastJarInfo = this.jarInfoMap.get(firstDirName);
        if (this.lastJarInfo == null) {
            System.err.println("\u5408\u5e76\u540e\u7684jar\u5305\u4e2d\u51fa\u73b0\u7684\u540d\u79f0\u672a\u8bb0\u5f55\u8fc7: " + jarEntryName);
        }
        return true;
    }
}

