/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.parser;

import com.adrninistrator.javacg.common.JavaCGCommonNameConstants;
import com.adrninistrator.javacg.conf.JavaCGConfInfo;
import com.adrninistrator.javacg.dto.classes.ClassImplementsMethodInfo;
import com.adrninistrator.javacg.dto.jar.ClassAndJarNum;
import com.adrninistrator.javacg.dto.jar.JarInfo;
import com.adrninistrator.javacg.dto.method.MethodAndArgs;
import com.adrninistrator.javacg.extensions.code_parser.JarEntryOtherFileParser;
import com.adrninistrator.javacg.extensions.manager.ExtensionsManager;
import com.adrninistrator.javacg.parser.AbstractJarEntryParser;
import com.adrninistrator.javacg.spring.DefineSpringBeanByAnnotationHandler;
import com.adrninistrator.javacg.util.JavaCGByteCodeUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.commons.lang3.StringUtils;

public class JarEntryPreHandle1Parser
extends AbstractJarEntryParser {
    private Map<String, ClassImplementsMethodInfo> classImplementsMethodInfoMap;
    private Map<String, List<MethodAndArgs>> interfaceMethodWithArgsMap;
    private Map<String, Boolean> runnableImplClassMap;
    private Map<String, Boolean> callableImplClassMap;
    private Map<String, Boolean> transactionCallbackImplClassMap;
    private Map<String, Boolean> transactionCallbackWithoutResultChildClassMap;
    private Map<String, Boolean> threadChildClassMap;
    private Set<String> classExtendsSet;
    private Set<String> interfaceExtendsSet;
    private ClassAndJarNum classAndJarNum;
    private final ExtensionsManager extensionsManager;
    private final DefineSpringBeanByAnnotationHandler defineSpringBeanByAnnotationHandler;

    public JarEntryPreHandle1Parser(JavaCGConfInfo javaCGConfInfo, Map<String, JarInfo> jarInfoMap, DefineSpringBeanByAnnotationHandler defineSpringBeanByAnnotationHandler, ExtensionsManager extensionsManager) {
        super(javaCGConfInfo, jarInfoMap);
        this.defineSpringBeanByAnnotationHandler = defineSpringBeanByAnnotationHandler;
        this.extensionsManager = extensionsManager;
    }

    @Override
    protected boolean handleEntry(JarInputStream jarInputStream, String jarEntryName) throws IOException {
        if (this.tryHandleClassEntry(jarInputStream, jarEntryName)) {
            return true;
        }
        String jarEntryFileExt = StringUtils.substringAfterLast((String)jarEntryName, (String)".");
        List<JarEntryOtherFileParser> jarEntryOtherFileParserList = this.extensionsManager.getJarEntryOtherFileParserList(jarEntryFileExt);
        if (jarEntryOtherFileParserList == null) {
            return true;
        }
        InputStream cachedInputStream = JavaCGUtil.cacheInputStream(jarInputStream);
        if (cachedInputStream == null) {
            return false;
        }
        for (JarEntryOtherFileParser jarEntryOtherFileParser : jarEntryOtherFileParserList) {
            jarEntryOtherFileParser.parseJarEntryOtherFile(cachedInputStream, jarEntryName);
            cachedInputStream.reset();
        }
        return true;
    }

    @Override
    protected boolean handleClassEntry(JavaClass javaClass, String jarEntryName) {
        this.classAndJarNum.put(javaClass.getClassName(), this.lastJarInfo.getJarNum());
        if (javaClass.isInterface()) {
            this.preHandle1Interface(javaClass);
            return true;
        }
        this.preHandle1Class(javaClass);
        if (this.javaCGConfInfo.isParseMethodCallTypeValue()) {
            return this.defineSpringBeanByAnnotationHandler.recordSpringBeanInfo(javaClass);
        }
        return true;
    }

    private void preHandle1Interface(JavaClass interfaceClass) {
        String[] superInterfaceNames;
        if (interfaceClass.isAnnotation()) {
            return;
        }
        String interfaceName = interfaceClass.getClassName();
        Method[] methods = interfaceClass.getMethods();
        if (methods != null && methods.length > 0 && this.interfaceMethodWithArgsMap.get(interfaceName) == null) {
            List<MethodAndArgs> interfaceMethodWithArgsList = JavaCGByteCodeUtil.genInterfaceMethodWithArgs(methods);
            this.interfaceMethodWithArgsMap.put(interfaceName, interfaceMethodWithArgsList);
        }
        if ((superInterfaceNames = interfaceClass.getInterfaceNames()).length > 0) {
            this.interfaceExtendsSet.add(interfaceName);
            this.interfaceExtendsSet.addAll(Arrays.asList(superInterfaceNames));
        }
    }

    private void preHandle1Class(JavaClass javaClass) {
        String superClassName;
        String className = javaClass.getClassName();
        String[] interfaceNames = javaClass.getInterfaceNames();
        Method[] methods = javaClass.getMethods();
        if (interfaceNames.length > 0 && methods != null && methods.length > 0 && this.classImplementsMethodInfoMap.get(className) == null) {
            ArrayList<String> interfaceNameList = new ArrayList<String>(interfaceNames.length);
            interfaceNameList.addAll(Arrays.asList(interfaceNames));
            List<MethodAndArgs> implClassMethodWithArgsList = JavaCGByteCodeUtil.genImplClassMethodWithArgs(methods);
            this.classImplementsMethodInfoMap.put(className, new ClassImplementsMethodInfo(interfaceNameList, implClassMethodWithArgsList));
            if (!javaClass.isAbstract()) {
                if (interfaceNameList.contains(JavaCGCommonNameConstants.CLASS_NAME_RUNNABLE)) {
                    this.runnableImplClassMap.put(className, Boolean.FALSE);
                }
                if (interfaceNameList.contains(JavaCGCommonNameConstants.CLASS_NAME_CALLABLE)) {
                    this.callableImplClassMap.put(className, Boolean.FALSE);
                }
                if (interfaceNameList.contains("org.springframework.transaction.support.TransactionCallback")) {
                    this.transactionCallbackImplClassMap.put(className, Boolean.FALSE);
                }
            }
        }
        if (JavaCGCommonNameConstants.CLASS_NAME_THREAD.equals(superClassName = javaClass.getSuperclassName())) {
            this.threadChildClassMap.put(className, Boolean.FALSE);
        } else if (JavaCGCommonNameConstants.CLASS_NAME_TIMER_TASK.equals(superClassName)) {
            this.runnableImplClassMap.put(className, Boolean.FALSE);
        } else if ("org.springframework.transaction.support.TransactionCallbackWithoutResult".equals(superClassName)) {
            this.transactionCallbackWithoutResultChildClassMap.put(className, Boolean.FALSE);
        }
        if (!JavaCGUtil.isClassInJdk(superClassName)) {
            this.classExtendsSet.add(className);
            this.classExtendsSet.add(superClassName);
        }
    }

    public void setClassImplementsMethodInfoMap(Map<String, ClassImplementsMethodInfo> classImplementsMethodInfoMap) {
        this.classImplementsMethodInfoMap = classImplementsMethodInfoMap;
    }

    public void setInterfaceMethodWithArgsMap(Map<String, List<MethodAndArgs>> interfaceMethodWithArgsMap) {
        this.interfaceMethodWithArgsMap = interfaceMethodWithArgsMap;
    }

    public void setRunnableImplClassMap(Map<String, Boolean> runnableImplClassMap) {
        this.runnableImplClassMap = runnableImplClassMap;
    }

    public void setCallableImplClassMap(Map<String, Boolean> callableImplClassMap) {
        this.callableImplClassMap = callableImplClassMap;
    }

    public void setTransactionCallbackImplClassMap(Map<String, Boolean> transactionCallbackImplClassMap) {
        this.transactionCallbackImplClassMap = transactionCallbackImplClassMap;
    }

    public void setTransactionCallbackWithoutResultChildClassMap(Map<String, Boolean> transactionCallbackWithoutResultChildClassMap) {
        this.transactionCallbackWithoutResultChildClassMap = transactionCallbackWithoutResultChildClassMap;
    }

    public void setThreadChildClassMap(Map<String, Boolean> threadChildClassMap) {
        this.threadChildClassMap = threadChildClassMap;
    }

    public void setClassExtendsSet(Set<String> classExtendsSet) {
        this.classExtendsSet = classExtendsSet;
    }

    public void setInterfaceExtendsSet(Set<String> interfaceExtendsSet) {
        this.interfaceExtendsSet = interfaceExtendsSet;
    }

    public void setClassAndJarNum(ClassAndJarNum classAndJarNum) {
        this.classAndJarNum = classAndJarNum;
    }
}

