/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.parser;

import com.adrninistrator.javacg.conf.JavaCGConfInfo;
import com.adrninistrator.javacg.dto.classes.ClassExtendsMethodInfo;
import com.adrninistrator.javacg.dto.interfaces.InterfaceExtendsMethodInfo;
import com.adrninistrator.javacg.dto.jar.JarInfo;
import com.adrninistrator.javacg.dto.method.MethodAndArgs;
import com.adrninistrator.javacg.parser.AbstractJarEntryParser;
import com.adrninistrator.javacg.spring.UseSpringBeanByAnnotationHandler;
import com.adrninistrator.javacg.util.JavaCGByteCodeUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import org.apache.bcel.classfile.AccessFlags;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class JarEntryPreHandle2Parser
extends AbstractJarEntryParser {
    private Set<String> classExtendsSet;
    private Map<String, ClassExtendsMethodInfo> classExtendsMethodInfoMap;
    private Map<String, List<String>> childrenClassMap;
    private Set<String> interfaceExtendsSet;
    private Map<String, InterfaceExtendsMethodInfo> interfaceExtendsMethodInfoMap;
    private Map<String, List<String>> childrenInterfaceMap;
    private final UseSpringBeanByAnnotationHandler useSpringBeanByAnnotationHandler;

    public JarEntryPreHandle2Parser(JavaCGConfInfo javaCGConfInfo, Map<String, JarInfo> jarInfoMap, UseSpringBeanByAnnotationHandler useSpringBeanByAnnotationHandler) {
        super(javaCGConfInfo, jarInfoMap);
        this.useSpringBeanByAnnotationHandler = useSpringBeanByAnnotationHandler;
    }

    @Override
    protected boolean handleEntry(JarInputStream jarInputStream, String jarEntryName) throws IOException {
        this.tryHandleClassEntry(jarInputStream, jarEntryName);
        return true;
    }

    @Override
    protected boolean handleClassEntry(JavaClass javaClass, String jarEntryName) {
        if (javaClass.isClass()) {
            this.findClassExtendsInfo(javaClass);
            if (this.javaCGConfInfo.isParseMethodCallTypeValue()) {
                this.useSpringBeanByAnnotationHandler.recordClassFieldsWithSpringAnnotation(javaClass);
            }
            return true;
        }
        this.findInterfaceExtendsInfo(javaClass);
        return true;
    }

    private void findClassExtendsInfo(JavaClass javaClass) {
        String className = javaClass.getClassName();
        if (!this.classExtendsSet.contains(className) || this.classExtendsMethodInfoMap.get(className) != null) {
            return;
        }
        String superClassName = javaClass.getSuperclassName();
        if (!JavaCGUtil.isClassInJdk(superClassName)) {
            List childrenClassList = this.childrenClassMap.computeIfAbsent(superClassName, k -> new ArrayList());
            childrenClassList.add(className);
        }
        HashMap<MethodAndArgs, Integer> methodAttributeMap = new HashMap<MethodAndArgs, Integer>();
        for (Method method : javaClass.getMethods()) {
            String methodName = method.getName();
            if (!JavaCGByteCodeUtil.checkExtendsMethod(methodName, (AccessFlags)method)) continue;
            methodAttributeMap.put(new MethodAndArgs(methodName, method.getArgumentTypes()), method.getAccessFlags());
        }
        this.classExtendsMethodInfoMap.put(className, new ClassExtendsMethodInfo(javaClass.getAccessFlags(), superClassName, methodAttributeMap));
    }

    private void findInterfaceExtendsInfo(JavaClass interfaceClass) {
        String[] superInterfaceNames;
        String interfaceName = interfaceClass.getClassName();
        if (interfaceClass.isAnnotation() || !this.interfaceExtendsSet.contains(interfaceName) || this.interfaceExtendsMethodInfoMap.get(interfaceName) != null) {
            return;
        }
        for (String superInterfaceName : superInterfaceNames = interfaceClass.getInterfaceNames()) {
            List childrenInterfaceList = this.childrenInterfaceMap.computeIfAbsent(superInterfaceName, k -> new ArrayList());
            childrenInterfaceList.add(interfaceName);
        }
        ArrayList<MethodAndArgs> methodAttributeList = new ArrayList<MethodAndArgs>();
        for (Method method : interfaceClass.getMethods()) {
            methodAttributeList.add(new MethodAndArgs(method.getName(), method.getArgumentTypes()));
        }
        this.interfaceExtendsMethodInfoMap.put(interfaceName, new InterfaceExtendsMethodInfo(Arrays.asList(superInterfaceNames), methodAttributeList));
    }

    public void setClassExtendsSet(Set<String> classExtendsSet) {
        this.classExtendsSet = classExtendsSet;
    }

    public void setClassExtendsMethodInfoMap(Map<String, ClassExtendsMethodInfo> classExtendsMethodInfoMap) {
        this.classExtendsMethodInfoMap = classExtendsMethodInfoMap;
    }

    public void setChildrenClassMap(Map<String, List<String>> childrenClassMap) {
        this.childrenClassMap = childrenClassMap;
    }

    public void setInterfaceExtendsSet(Set<String> interfaceExtendsSet) {
        this.interfaceExtendsSet = interfaceExtendsSet;
    }

    public void setInterfaceExtendsMethodInfoMap(Map<String, InterfaceExtendsMethodInfo> interfaceExtendsMethodInfoMap) {
        this.interfaceExtendsMethodInfoMap = interfaceExtendsMethodInfoMap;
    }

    public void setChildrenInterfaceMap(Map<String, List<String>> childrenInterfaceMap) {
        this.childrenInterfaceMap = childrenInterfaceMap;
    }
}

