/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.util;

import com.adrninistrator.javacg.dto.method.JavaCGMethodInfo;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.BootstrapMethod;
import org.apache.bcel.classfile.BootstrapMethods;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantMethodHandle;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.Type;

public class JavaCGBootstrapMethodUtil {
    public static BootstrapMethod getBootstrapMethod(JavaClass javaClass, int index) {
        for (Attribute attribute : javaClass.getAttributes()) {
            BootstrapMethods bootstrapMethods;
            BootstrapMethod[] bootstrapMethodArray;
            if (!(attribute instanceof BootstrapMethods) || (bootstrapMethodArray = (bootstrapMethods = (BootstrapMethods)attribute).getBootstrapMethods()) == null || bootstrapMethodArray.length <= index) continue;
            return bootstrapMethodArray[index];
        }
        return null;
    }

    public static JavaCGMethodInfo getBootstrapMethodInfo(BootstrapMethod bootstrapMethod, JavaClass javaClass) {
        for (int argIndex : bootstrapMethod.getBootstrapArguments()) {
            JavaCGMethodInfo javaCGMethodInfo;
            Constant constantArg = javaClass.getConstantPool().getConstant(argIndex);
            if (!(constantArg instanceof ConstantMethodHandle) || (javaCGMethodInfo = JavaCGBootstrapMethodUtil.getMethodFromConstantMethodHandle((ConstantMethodHandle)constantArg, javaClass)) == null) continue;
            return javaCGMethodInfo;
        }
        return null;
    }

    public static JavaCGMethodInfo getMethodFromConstantMethodHandle(ConstantMethodHandle constantMethodHandle, JavaClass javaClass) {
        ConstantPool constantPool = javaClass.getConstantPool();
        Constant constantCP = constantPool.getConstant(constantMethodHandle.getReferenceIndex());
        if (!(constantCP instanceof ConstantCP)) {
            System.err.println("### \u4e0d\u6ee1\u8db3instanceof ConstantCP " + constantCP.getClass().getName());
            return null;
        }
        ConstantCP constantClassAndMethod = (ConstantCP)constantCP;
        String className = constantPool.getConstantString(constantClassAndMethod.getClassIndex(), (byte)7);
        className = Utility.compactClassName((String)className, (boolean)false);
        Constant constantNAT = constantPool.getConstant(constantClassAndMethod.getNameAndTypeIndex());
        if (!(constantNAT instanceof ConstantNameAndType)) {
            System.err.println("### \u4e0d\u6ee1\u8db3instanceof ConstantNameAndType " + constantNAT.getClass().getName());
            return null;
        }
        ConstantNameAndType constantNameAndType = (ConstantNameAndType)constantNAT;
        String methodName = constantPool.constantToString(constantNameAndType.getNameIndex(), (byte)1);
        String methodArgs = constantPool.constantToString(constantNameAndType.getSignatureIndex(), (byte)1);
        if (methodName != null && methodArgs != null) {
            return new JavaCGMethodInfo(className, methodName, Type.getArgumentTypes((String)methodArgs));
        }
        System.err.println("### \u83b7\u53d6\u65b9\u6cd5\u4fe1\u606f\u5931\u8d25 " + javaClass.getClassName() + " " + className + " " + methodName + " " + methodArgs);
        return null;
    }

    private JavaCGBootstrapMethodUtil() {
        throw new IllegalStateException("illegal");
    }
}

