/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.util;

import com.adrninistrator.javacg.exceptions.JavaCGRuntimeException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class JavaCGFileUtil {
    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean deleteFile(File file) {
        try {
            Files.delete(file.toPath());
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void write2FileWithTab(Writer writer, String ... data) throws IOException {
        writer.write(StringUtils.join((Object[])data, (String)"\t") + "\n");
    }

    public static void write2FileNoLF(Writer writer, String data) throws IOException {
        writer.write(data);
    }

    public static boolean isClassFile(String fileName) {
        if (fileName == null) {
            return false;
        }
        return fileName.toLowerCase().endsWith(".class");
    }

    public static boolean isDirectoryExists(String dirPath, boolean tryMake) {
        File file = new File(dirPath);
        if (file.exists()) {
            if (file.isDirectory()) {
                return true;
            }
            System.err.println("\u5df2\u5b58\u5728\u6587\u4ef6: " + dirPath);
            return false;
        }
        if (!tryMake) {
            return false;
        }
        if (file.mkdirs()) {
            System.out.println("\u521b\u5efa\u76ee\u5f55: " + dirPath);
            return true;
        }
        System.err.println("\u521b\u5efa\u76ee\u5f55\u5931\u8d25: " + dirPath);
        return false;
    }

    public static BufferedWriter genBufferedWriter(String filePath) throws FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), StandardCharsets.UTF_8));
    }

    public static File findFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            System.out.println("\u901a\u8fc7\u6587\u4ef6\u8def\u5f84\u83b7\u53d6\u6587\u4ef6 " + filePath);
            return file;
        }
        URL url = JavaCGFileUtil.class.getResource("/" + filePath);
        if (url != null && "file".equals(url.getProtocol())) {
            System.out.println("\u4ececlasspath\u4e2d\u83b7\u53d6\u6587\u4ef6 " + url);
            try {
                return new File(url.toURI());
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static InputStream getFileInputStream(String filePath) throws FileNotFoundException {
        File file = JavaCGFileUtil.findFile(filePath);
        if (file != null) {
            return new FileInputStream(file);
        }
        InputStream inputStream = JavaCGFileUtil.class.getResourceAsStream("/" + filePath);
        if (inputStream == null) {
            System.err.println("\u672a\u627e\u5230\u6587\u4ef6 " + filePath);
            throw new JavaCGRuntimeException("\u672a\u627e\u5230\u6587\u4ef6 " + filePath);
        }
        System.out.println("\u4ecejar\u5305\u4e2d\u83b7\u53d6\u6587\u4ef6 " + JavaCGFileUtil.class.getResource("/" + filePath));
        return inputStream;
    }

    public static Set<String> readFile2Set(String filePath) {
        return JavaCGFileUtil.readFile2Set(filePath, "#");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<String> readFile2Set(String filePath, String ignorePrefix) {
        try (BufferedReader br = JavaCGFileUtil.genBufferedReader(JavaCGFileUtil.getFileInputStream(filePath));){
            String line;
            HashSet<String> set = new HashSet<String>();
            boolean checkIgnore = StringUtils.isNotBlank((CharSequence)ignorePrefix);
            while ((line = br.readLine()) != null) {
                if (!StringUtils.isNotBlank((CharSequence)line) || checkIgnore && line.startsWith(ignorePrefix)) continue;
                set.add(line);
            }
            HashSet<String> hashSet = set;
            return hashSet;
        }
        catch (Exception e) {
            System.err.println("\u5904\u7406\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38 " + filePath);
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> readFile2List(String filePath) {
        return JavaCGFileUtil.readFile2List(filePath, "#");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readFile2List(String filePath, String ignorePrefix) {
        try (BufferedReader br = JavaCGFileUtil.genBufferedReader(JavaCGFileUtil.getFileInputStream(filePath));){
            String line;
            ArrayList<String> list = new ArrayList<String>();
            boolean checkIgnore = StringUtils.isNotBlank((CharSequence)ignorePrefix);
            while ((line = br.readLine()) != null) {
                if (!StringUtils.isNotBlank((CharSequence)line) || checkIgnore && line.startsWith(ignorePrefix)) continue;
                list.add(line);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            System.err.println("\u5904\u7406\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38 " + filePath);
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedReader genBufferedReader(String filePath) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), StandardCharsets.UTF_8));
    }

    public static BufferedReader genBufferedReader(File file) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
    }

    public static BufferedReader genBufferedReader(InputStream input) {
        return new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
    }

    private JavaCGFileUtil() {
        throw new IllegalStateException("illegal");
    }
}

