/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.util;

import com.adrninistrator.javacg.dto.method.JavaCGMethodInfo;
import org.apache.bcel.generic.Type;
import org.apache.commons.lang3.ArrayUtils;

public class JavaCGMethodUtil {
    public static String formatFullMethod(JavaCGMethodInfo javaCGMethodInfo) {
        return JavaCGMethodUtil.formatFullMethod(javaCGMethodInfo.getClassName(), javaCGMethodInfo.getMethodName(), javaCGMethodInfo.getMethodArgumentTypes());
    }

    public static String formatFullMethod(String className, String methodName, Type[] arguments) {
        return JavaCGMethodUtil.formatFullMethod(className, methodName, JavaCGMethodUtil.getArgListStr(arguments));
    }

    public static String formatFullMethod(String className, String methodName, String arguments) {
        return className + ":" + methodName + arguments;
    }

    public static String formatFullMethod(String className, String methodName, Class<?> ... argTypes) {
        return JavaCGMethodUtil.formatFullMethodWithArgs(className, JavaCGMethodUtil.formatMethodWithArgs(methodName, argTypes));
    }

    public static String formatFullMethodStr(String className, String methodName, String ... argTypes) {
        return JavaCGMethodUtil.formatFullMethodWithArgs(className, JavaCGMethodUtil.formatMethodWithArgsStr(methodName, argTypes));
    }

    public static String getArgListStr(Type[] arguments) {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < arguments.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(arguments[i].toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public static String formatFullMethodWithArgs(String className, String methodNameAndArgs) {
        return className + ":" + methodNameAndArgs;
    }

    public static String formatMethodWithArgs(String methodName, Class<?> ... argTypes) {
        StringBuilder sb = new StringBuilder(methodName).append("(");
        for (int i = 0; i < argTypes.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(argTypes[i].getName());
        }
        sb.append(")");
        return sb.toString();
    }

    public static String formatMethodWithArgsStr(String methodName, String ... argTypes) {
        if (ArrayUtils.isEmpty((Object[])argTypes)) {
            return methodName + "()";
        }
        StringBuilder sb = new StringBuilder(methodName).append("(");
        for (int i = 0; i < argTypes.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(argTypes[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    private JavaCGMethodUtil() {
        throw new IllegalStateException("illegal");
    }
}

