/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.mybatis_mysql_table_parser.entry;

import com.adrninistrator.mybatis_mysql_table_parser.common.enums.MySqlStatementEnum;
import com.adrninistrator.mybatis_mysql_table_parser.dto.MyBatisMySqlInfo;
import com.adrninistrator.mybatis_mysql_table_parser.dto.MySqlTableInfo;
import com.adrninistrator.mybatis_mysql_table_parser.entry.AbstractEntry;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Entry4GetMyBatisMySqlTableDetailInfo
extends AbstractEntry {
    private static final Logger logger = LoggerFactory.getLogger(Entry4GetMyBatisMySqlTableDetailInfo.class);

    public void getDetailInfo(String dirPath, String outputFilePath) {
        if (StringUtils.isBlank((CharSequence)dirPath)) {
            logger.error("\u4f20\u5165\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilePath), StandardCharsets.UTF_8));){
            String fileHeader = "# MyBatis-Mapper\u7c7b\u540d\tMyBatis-Mapper\u65b9\u6cd5\u540d\tsql\u8bed\u53e5\u7c7b\u578b\t\u8868\u540d\n";
            writer.write(fileHeader);
            this.handleDirectory(dirPath);
            ArrayList mapperClassNameList = new ArrayList(this.myBatisSqlInfoMap.keySet());
            Collections.sort(mapperClassNameList);
            for (String mapperClassName : mapperClassNameList) {
                MyBatisMySqlInfo myBatisSqlInfo = (MyBatisMySqlInfo)this.myBatisSqlInfoMap.get(mapperClassName);
                Map<String, MySqlTableInfo> mySqlTableInfoMap = myBatisSqlInfo.getMySqlTableInfoMap();
                ArrayList<String> mapperMethodNameList = new ArrayList<String>(mySqlTableInfoMap.keySet());
                Collections.sort(mapperMethodNameList);
                for (String mapperMethodName : mapperMethodNameList) {
                    MySqlTableInfo mySqlTableInfo = mySqlTableInfoMap.get(mapperMethodName);
                    this.recordTableInfo(writer, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_SELECT, mySqlTableInfo.getSelectTableList());
                    this.recordTableInfo(writer, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_SELECT_4_UPDATE, mySqlTableInfo.getSelect4UpdateTableList());
                    this.recordTableInfo(writer, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_INSERT, mySqlTableInfo.getInsertTableList());
                    this.recordTableInfo(writer, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_INSERT_IGNORE, mySqlTableInfo.getInsertIgnoreTableList());
                    this.recordTableInfo(writer, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_INSERT_OR_UPDATE, mySqlTableInfo.getInsertOrUpdateTableList());
                    this.recordTableInfo(writer, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_REPLACE, mySqlTableInfo.getReplaceTableList());
                    this.recordTableInfo(writer, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_UPDATE, mySqlTableInfo.getUpdateTableList());
                    this.recordTableInfo(writer, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_DELETE, mySqlTableInfo.getDeleteTableList());
                    this.recordTableInfo(writer, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_ALTER, mySqlTableInfo.getAlterTableList());
                    this.recordTableInfo(writer, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_TRUNCATE, mySqlTableInfo.getTruncateTableList());
                    this.recordTableInfo(writer, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_CREATE, mySqlTableInfo.getCreateTableList());
                    this.recordTableInfo(writer, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_DROP, mySqlTableInfo.getDropTableList());
                }
            }
        }
        catch (Exception e) {
            logger.error("error ", (Throwable)e);
        }
    }

    private void recordTableInfo(BufferedWriter writer, String mapperClassName, String mapperMethodName, MySqlStatementEnum mySqlStatementEnum, List<String> tableList) throws IOException {
        if (tableList.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Collections.sort(tableList);
        for (String table : tableList) {
            stringBuilder.append(mapperClassName).append("\t").append(mapperMethodName).append("\t").append(mySqlStatementEnum.getType()).append("\t").append(table).append("\n");
        }
        writer.write(stringBuilder.toString());
    }
}

