/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.config;

import com.github.jaemon.dinger.config.BeanConfiguration;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnMissingBean(name={"dingerRestTemplate"})
@ConfigurationProperties(prefix="spring.dinger.http-client")
@AutoConfigureAfter(value={BeanConfiguration.class})
public class DingerHttpClientConfig {
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration connectTimeout = Duration.ofSeconds(30L);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration readTimeout = Duration.ofSeconds(30L);

    @Bean(name={"dingerRestTemplate"})
    public RestTemplate restTemplate(ClientHttpRequestFactory dingerClientHttpRequestFactory) {
        return new RestTemplate(dingerClientHttpRequestFactory);
    }

    @Bean(name={"dingerClientHttpRequestFactory"})
    public ClientHttpRequestFactory dingerClientHttpRequestFactory() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout((int)this.readTimeout.toMillis());
        factory.setConnectTimeout((int)this.connectTimeout.toMillis());
        return factory;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }
}

