/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.core;

import com.github.jaemon.dinger.core.DingerDefinition;
import com.github.jaemon.dinger.core.DingerHelper;
import com.github.jaemon.dinger.core.DingerInvocationHandler;
import com.github.jaemon.dinger.core.annatations.DingerClose;
import com.github.jaemon.dinger.core.entity.DingerResponse;
import com.github.jaemon.dinger.core.entity.MsgType;
import com.github.jaemon.dinger.core.entity.enums.DingerResponseCodeEnum;
import com.github.jaemon.dinger.core.entity.enums.DingerType;
import com.github.jaemon.dinger.core.entity.enums.IgnoreMethod;
import com.github.jaemon.dinger.core.session.Configuration;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingerHandleProxy
extends DingerInvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(DingerHandleProxy.class);

    public DingerHandleProxy(Configuration configuration) {
        this.dingerRobot = configuration.getDingerRobot();
        this.dingerProperties = configuration.getDingerProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> dingerClass = method.getDeclaringClass();
        String methodName = method.getName();
        if (ignoreMethodMap.containsKey(methodName)) {
            return ((IgnoreMethod)((Object)ignoreMethodMap.get(methodName))).execute(this, args);
        }
        if (dingerClass.isAnnotationPresent(DingerClose.class)) {
            return null;
        }
        if (method.isAnnotationPresent(DingerClose.class)) {
            return null;
        }
        String dingerClassName = dingerClass.getName();
        String keyName = dingerClassName + "." + methodName;
        try {
            DingerResponse dingerResponse;
            DingerType useDinger = this.dingerType(method);
            DingerDefinition dingerDefinition = this.dingerDefinition(useDinger, dingerClassName, keyName);
            if (dingerDefinition == null) {
                dingerResponse = DingerResponse.failed(DingerResponseCodeEnum.MESSAGE_TYPE_UNSUPPORTED, String.format("method %s does not support dinger %s.", new Object[]{keyName, useDinger}));
            } else {
                Map<String, Object> params = this.paramsHandler(method, dingerDefinition, args);
                MsgType message = this.transfer(dingerDefinition, params);
                dingerResponse = this.dingerRobot.send(message);
            }
            Object object = this.resultHandler(method.getReturnType(), dingerResponse);
            return object;
        }
        finally {
            DingerHelper.clearDinger();
        }
    }
}

