/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.guava;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.guava.CaffeinatedGuavaCache;
import com.github.benmanes.caffeine.guava.CaffeinatedGuavaLoadingCache;
import com.google.common.cache.Cache;
import com.google.common.cache.LoadingCache;
import com.google.errorprone.annotations.CheckReturnValue;
import java.lang.reflect.Method;

public final class CaffeinatedGuava {
    private CaffeinatedGuava() {
    }

    @CheckReturnValue
    public static <K, V, K1 extends K, V1 extends V> Cache<K1, V1> build(Caffeine<K, V> builder) {
        return new CaffeinatedGuavaCache(builder.build());
    }

    @CheckReturnValue
    public static <K, V, K1 extends K, V1 extends V> LoadingCache<K1, V1> build(Caffeine<K, V> builder, com.google.common.cache.CacheLoader<? super K1, V1> loader) {
        return CaffeinatedGuava.build(builder, CaffeinatedGuava.hasLoadAll(loader) ? new CaffeinatedGuavaLoadingCache.InternalBulkLoader<K1, V1>(loader) : new CaffeinatedGuavaLoadingCache.InternalSingleLoader<K1, V1>(loader));
    }

    @CheckReturnValue
    public static <K, V, K1 extends K, V1 extends V> LoadingCache<K1, V1> build(Caffeine<K, V> builder, CacheLoader<? super K1, V1> loader) {
        return new CaffeinatedGuavaLoadingCache(builder.build(loader));
    }

    @CheckReturnValue
    public static <K, V> CacheLoader<K, V> caffeinate(com.google.common.cache.CacheLoader<K, V> loader) {
        return CaffeinatedGuava.hasLoadAll(loader) ? new CaffeinatedGuavaLoadingCache.ExternalBulkLoader<K, V>(loader) : new CaffeinatedGuavaLoadingCache.ExternalSingleLoader<K, V>(loader);
    }

    static boolean hasLoadAll(com.google.common.cache.CacheLoader<?, ?> cacheLoader) {
        return CaffeinatedGuava.hasMethod(cacheLoader, "loadAll", Iterable.class);
    }

    static boolean hasMethod(com.google.common.cache.CacheLoader<?, ?> cacheLoader, String name, Class<?> ... paramTypes) {
        try {
            Method method = cacheLoader.getClass().getMethod(name, paramTypes);
            return method.getDeclaringClass() != com.google.common.cache.CacheLoader.class;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }
}

