/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.mergepatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.mergepatch.JsonMergePatch;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;

final class ObjectMergePatch
extends JsonMergePatch {
    private final Map<String, JsonNode> fields;
    private final Set<String> removals;

    ObjectMergePatch(JsonNode content) {
        super(content);
        this.fields = JacksonUtils.asMap((JsonNode)content);
        this.removals = Sets.newHashSet();
        for (Map.Entry<String, JsonNode> entry : this.fields.entrySet()) {
            if (!entry.getValue().isNull()) continue;
            this.removals.add(entry.getKey());
        }
        this.fields.keySet().removeAll(this.removals);
    }

    @Override
    public JsonNode apply(JsonNode input) throws JsonPatchException {
        if (!input.isObject()) {
            return ObjectMergePatch.mapToNode(this.fields);
        }
        Map map = JacksonUtils.asMap((JsonNode)input);
        map.keySet().removeAll(this.removals);
        for (Map.Entry entry : map.entrySet()) {
            String memberName = (String)entry.getKey();
            JsonNode patchNode = this.fields.get(memberName);
            if (patchNode == null) continue;
            if (!patchNode.isContainerNode()) {
                entry.setValue(patchNode);
                continue;
            }
            JsonMergePatch patch = JsonMergePatch.fromJson(patchNode);
            entry.setValue(patch.apply((JsonNode)entry.getValue()));
        }
        for (String string : Sets.difference(this.fields.keySet(), map.keySet())) {
            map.put(string, ObjectMergePatch.clearNulls(this.fields.get(string)));
        }
        return ObjectMergePatch.mapToNode(map);
    }

    private static JsonNode mapToNode(Map<String, JsonNode> map) {
        ObjectNode ret = FACTORY.objectNode();
        return ret.putAll(map);
    }
}

