/*
 * Decompiled with CFR 0.152.
 */
package com.github.gundy.semver4j.model;

import com.github.gundy.hidden.antlr.v4.runtime.ANTLRInputStream;
import com.github.gundy.hidden.antlr.v4.runtime.CommonTokenStream;
import com.github.gundy.hidden.antlr.v4.runtime.tree.ParseTree;
import com.github.gundy.semver4j.generated.grammar.NodeSemverExpressionLexer;
import com.github.gundy.semver4j.generated.grammar.NodeSemverExpressionParser;
import com.github.gundy.semver4j.generated.grammar.NodeSemverVersionBaseVisitor;
import com.github.gundy.semver4j.generated.grammar.NodeSemverVersionLexer;
import com.github.gundy.semver4j.generated.grammar.NodeSemverVersionParser;
import com.github.gundy.semver4j.visitor.SemVerRangeExpressionVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private static final ForwardComparator FORWARD_COMPARATOR = new ForwardComparator();
    private static final ReverseComparator REVERSE_COMPARATOR = new ReverseComparator();
    private final int major;
    private final int minor;
    private final int patch;
    private final List<Identifier> preReleaseIdentifiers;
    private final List<Identifier> buildIdentifiers;

    private Version(int major, int minor, int patch, List<Identifier> preReleaseIdentifiers, List<Identifier> buildIdentifiers) {
        if (major < 0) {
            throw new IllegalArgumentException("Major version must be >= 0");
        }
        this.major = major;
        if (minor < 0) {
            throw new IllegalArgumentException("Minor version must be >= 0");
        }
        this.minor = minor;
        if (patch < 0) {
            throw new IllegalArgumentException("Patch version must be >= 0");
        }
        this.patch = patch;
        if (preReleaseIdentifiers == null) {
            throw new IllegalArgumentException("Pre-release identifier list must not be null");
        }
        this.preReleaseIdentifiers = preReleaseIdentifiers;
        if (buildIdentifiers == null) {
            throw new IllegalArgumentException("Build identifier list must not be null");
        }
        this.buildIdentifiers = buildIdentifiers;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public List<Identifier> getPreReleaseIdentifiers() {
        return this.preReleaseIdentifiers;
    }

    public List<Identifier> getBuildIdentifiers() {
        return this.buildIdentifiers;
    }

    public Version incrementMajor() {
        return new Version(this.major + 1, 0, 0, Collections.<Identifier>emptyList(), Collections.<Identifier>emptyList());
    }

    public Version incrementMinor() {
        return new Version(this.major, this.minor + 1, 0, Collections.<Identifier>emptyList(), Collections.<Identifier>emptyList());
    }

    public Version incrementPatch() {
        return new Version(this.major, this.minor, this.patch, Collections.<Identifier>emptyList(), Collections.<Identifier>emptyList());
    }

    public boolean satisfies(String expression) {
        ParseTree tree = Version.getParseTreeForRange(expression);
        SemVerRangeExpressionVisitor visitor = new SemVerRangeExpressionVisitor(this);
        return (Boolean)visitor.visit(tree);
    }

    public static Version maxVersionSatisfying(Collection<Version> versions, String range) {
        ParseTree tree = Version.getParseTreeForRange(range);
        ArrayList<Version> matchingVersions = new ArrayList<Version>();
        for (Version version : versions) {
            if (!((Boolean)new SemVerRangeExpressionVisitor(version).visit(tree)).booleanValue()) continue;
            matchingVersions.add(version);
        }
        Collections.sort(matchingVersions, Version.reverseComparator());
        if (matchingVersions.size() > 0) {
            return (Version)matchingVersions.get(0);
        }
        return null;
    }

    private static ParseTree getParseTreeForRange(String range) {
        ANTLRInputStream reader = new ANTLRInputStream(range);
        NodeSemverExpressionLexer lexer = new NodeSemverExpressionLexer(reader);
        lexer.removeErrorListeners();
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        NodeSemverExpressionParser parser = new NodeSemverExpressionParser(tokens);
        parser.removeErrorListeners();
        return parser.rangeSet();
    }

    public static String maxSatisfying(Collection<String> versionsToTest, String range) {
        ParseTree tree = Version.getParseTreeForRange(range);
        ArrayList<Version> matchingVersions = new ArrayList<Version>();
        for (String strVersion : versionsToTest) {
            Version version = Version.builder().fromString(strVersion);
            if (!((Boolean)new SemVerRangeExpressionVisitor(version).visit(tree)).booleanValue()) continue;
            matchingVersions.add(version);
        }
        Collections.sort(matchingVersions, Version.reverseComparator());
        if (matchingVersions.size() > 0) {
            return ((Version)matchingVersions.get(0)).toString();
        }
        return null;
    }

    public static Version fromString(String version) {
        return Version.builder().fromString(version);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        String preRelease = Version.join(".", this.preReleaseIdentifiers);
        String build = Version.join(".", this.buildIdentifiers);
        return "" + this.major + "." + this.minor + "." + this.patch + (this.preReleaseIdentifiers.size() > 0 ? "-" + preRelease : "") + (this.buildIdentifiers.size() > 0 ? "+" + build : "");
    }

    private static String join(String joiner, Collection<?> objects) {
        Iterator<?> i = objects.iterator();
        StringBuilder sb = new StringBuilder();
        while (i.hasNext()) {
            sb.append(i.next().toString());
            if (!i.hasNext()) continue;
            sb.append(joiner);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version that = (Version)o;
        if (this.major != that.major) {
            return false;
        }
        if (this.minor != that.minor) {
            return false;
        }
        if (this.patch != that.patch) {
            return false;
        }
        if (!this.preReleaseIdentifiers.equals(that.preReleaseIdentifiers)) {
            return false;
        }
        return this.buildIdentifiers.equals(that.buildIdentifiers);
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        result = 31 * result + this.preReleaseIdentifiers.hashCode();
        result = 31 * result + this.buildIdentifiers.hashCode();
        return result;
    }

    @Override
    public int compareTo(Version o) {
        return FORWARD_COMPARATOR.compare(this, o);
    }

    public static final Comparator<Version> forwardComparator() {
        return FORWARD_COMPARATOR;
    }

    public static final Comparator<Version> reverseComparator() {
        return REVERSE_COMPARATOR;
    }

    public static final class Identifier
    implements Comparable<Identifier> {
        private static final Pattern PATTERN_NUMERIC = Pattern.compile("^[0-9]+$");
        private static final Pattern PATTERN_VALID = Pattern.compile("[\\-A-Za-z0-9]+");
        private final String identifier;
        private final boolean isNumeric;

        private Identifier(String identifier) {
            if (!PATTERN_VALID.matcher(identifier).matches()) {
                throw new IllegalArgumentException("Identifier must match [-A-Za-z0-9]+");
            }
            this.identifier = identifier;
            this.isNumeric = PATTERN_NUMERIC.matcher(identifier).matches();
        }

        public static Identifier fromString(String identifier) {
            return new Identifier(identifier);
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public boolean isNumeric() {
            return this.isNumeric;
        }

        public String toString() {
            return this.identifier;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Identifier that = (Identifier)o;
            return this.identifier != null ? this.identifier.equals(that.identifier) : that.identifier == null;
        }

        public int hashCode() {
            return this.identifier != null ? this.identifier.hashCode() : 0;
        }

        @Override
        public int compareTo(Identifier o) {
            if (this.isNumeric() && !o.isNumeric()) {
                return -1;
            }
            if (!this.isNumeric() && o.isNumeric()) {
                return 1;
            }
            if (this.isNumeric()) {
                return Long.valueOf(this.getIdentifier()).compareTo(Long.valueOf(o.getIdentifier()));
            }
            return this.getIdentifier().compareTo(o.getIdentifier());
        }
    }

    private static final class ReverseComparator
    extends ForwardComparator {
        private ReverseComparator() {
        }

        @Override
        public int compare(Version a, Version b) {
            return -super.compare(a, b);
        }
    }

    private static class ForwardComparator
    implements Comparator<Version> {
        private ForwardComparator() {
        }

        @Override
        public int compare(Version a, Version b) {
            if (a.major < b.major) {
                return -1;
            }
            if (a.major > b.major) {
                return 1;
            }
            if (a.minor < b.minor) {
                return -1;
            }
            if (a.minor > b.minor) {
                return 1;
            }
            if (a.patch < b.patch) {
                return -1;
            }
            if (a.patch > b.patch) {
                return 1;
            }
            return this.comparePreReleaseVersions(a, b);
        }

        private int comparePreReleaseVersions(Version a, Version b) {
            if (a.preReleaseIdentifiers.equals(b.preReleaseIdentifiers)) {
                return 0;
            }
            if (a.preReleaseIdentifiers.size() == 0 && b.preReleaseIdentifiers.size() != 0) {
                return 1;
            }
            if (b.preReleaseIdentifiers.size() == 0 && a.preReleaseIdentifiers.size() != 0) {
                return -1;
            }
            int length = a.preReleaseIdentifiers.size() < b.preReleaseIdentifiers.size() ? a.preReleaseIdentifiers.size() : b.preReleaseIdentifiers.size();
            for (int i = 0; i < length; ++i) {
                Identifier right;
                Identifier left = (Identifier)a.preReleaseIdentifiers.get(i);
                int result = left.compareTo(right = (Identifier)b.preReleaseIdentifiers.get(i));
                if (result == 0) continue;
                return result;
            }
            if (a.preReleaseIdentifiers.size() > b.preReleaseIdentifiers.size()) {
                return 1;
            }
            if (a.preReleaseIdentifiers.size() < b.preReleaseIdentifiers.size()) {
                return -1;
            }
            return 0;
        }
    }

    public static class Builder {
        private int major = 0;
        private int minor = 0;
        private int patch = 0;
        private final List<Identifier> preReleaseIdentifiers = new ArrayList<Identifier>();
        private final List<Identifier> buildIdentifiers = new ArrayList<Identifier>();

        public Builder major(int major) {
            this.major = major;
            return this;
        }

        public Builder minor(int minor) {
            this.minor = minor;
            return this;
        }

        public Builder patch(int patch) {
            this.patch = patch;
            return this;
        }

        public Builder preReleaseIdentifiers(List<Identifier> identifiers) {
            this.preReleaseIdentifiers.addAll(identifiers);
            return this;
        }

        public Builder buildIdentifiers(List<Identifier> identifiers) {
            this.buildIdentifiers.addAll(identifiers);
            return this;
        }

        public Version fromString(String version) {
            ANTLRInputStream reader = new ANTLRInputStream(version);
            NodeSemverVersionLexer lexer = new NodeSemverVersionLexer(reader);
            lexer.removeErrorListeners();
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            NodeSemverVersionParser parser = new NodeSemverVersionParser(tokens);
            parser.removeErrorListeners();
            NodeSemverVersionParser.FullySpecifiedVersionContext tree = parser.fullySpecifiedVersion();
            SemverVersionVisitor visitor = new SemverVersionVisitor();
            return (Version)visitor.visit(tree);
        }

        public Version build() {
            return new Version(this.major, this.minor, this.patch, Collections.unmodifiableList(this.preReleaseIdentifiers), Collections.unmodifiableList(this.buildIdentifiers));
        }

        private static class SemverVersionVisitor
        extends NodeSemverVersionBaseVisitor<Version> {
            private SemverVersionVisitor() {
            }

            @Override
            public Version visitFullySpecifiedVersion(NodeSemverVersionParser.FullySpecifiedVersionContext ctx) {
                Builder builder = Version.builder().major(this.parseOptionalInteger(ctx.major)).minor(this.parseOptionalInteger(ctx.minor)).patch(this.parseOptionalInteger(ctx.patch));
                if (ctx.preReleaseIdentifiers != null && ctx.preReleaseIdentifiers.identifier() != null) {
                    builder.preReleaseIdentifiers(this.convertIdentifiers(ctx.preReleaseIdentifiers.identifier()));
                }
                if (ctx.buildIdentifiers != null && ctx.buildIdentifiers.identifier() != null) {
                    builder.buildIdentifiers(this.convertIdentifiers(ctx.buildIdentifiers.identifier()));
                }
                return builder.build();
            }

            private int parseOptionalInteger(NodeSemverVersionParser.IntegerContext val) {
                if (val == null || val.getText() == null || "".equalsIgnoreCase(val.getText())) {
                    return 0;
                }
                return Integer.parseInt(val.getText());
            }

            private List<Identifier> convertIdentifiers(List<NodeSemverVersionParser.IdentifierContext> contexts) {
                ArrayList<Identifier> results = new ArrayList<Identifier>();
                for (NodeSemverVersionParser.IdentifierContext ctx : contexts) {
                    results.add(Identifier.fromString(ctx.getText()));
                }
                return results;
            }
        }
    }
}

