/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi.model.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import info.movito.themoviedbapi.model.core.AbstractJsonMapping;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TmdbConfiguration
extends AbstractJsonMapping {
    @JsonProperty(value="base_url")
    private String baseUrl;
    @JsonProperty(value="secure_base_url")
    private String secureBaseUrl;
    @JsonProperty(value="poster_sizes")
    private List<String> posterSizes;
    @JsonProperty(value="backdrop_sizes")
    private List<String> backdropSizes;
    @JsonProperty(value="profile_sizes")
    private List<String> profileSizes;
    @JsonProperty(value="logo_sizes")
    private List<String> logoSizes;

    public List<String> getBackdropSizes() {
        return this.backdropSizes;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public List<String> getPosterSizes() {
        return this.posterSizes;
    }

    public List<String> getProfileSizes() {
        return this.profileSizes;
    }

    public List<String> getLogoSizes() {
        return this.logoSizes;
    }

    public String getSecureBaseUrl() {
        return this.secureBaseUrl;
    }

    public void setBackdropSizes(List<String> backdropSizes) {
        this.backdropSizes = backdropSizes;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setPosterSizes(List<String> posterSizes) {
        this.posterSizes = posterSizes;
    }

    public void setProfileSizes(List<String> profileSizes) {
        this.profileSizes = profileSizes;
    }

    public void setLogoSizes(List<String> logoSizes) {
        this.logoSizes = logoSizes;
    }

    public void setSecureBaseUrl(String secureBaseUrl) {
        this.secureBaseUrl = secureBaseUrl;
    }

    public void clone(TmdbConfiguration config) {
        this.backdropSizes = config.getBackdropSizes();
        this.baseUrl = config.getBaseUrl();
        this.posterSizes = config.getPosterSizes();
        this.profileSizes = config.getProfileSizes();
        this.logoSizes = config.getLogoSizes();
    }

    public boolean isValidPosterSize(String posterSize) {
        if (StringUtils.isBlank((CharSequence)posterSize) || this.posterSizes.isEmpty()) {
            return false;
        }
        return this.posterSizes.contains(posterSize);
    }

    public boolean isValidBackdropSize(String backdropSize) {
        if (StringUtils.isBlank((CharSequence)backdropSize) || this.backdropSizes.isEmpty()) {
            return false;
        }
        return this.backdropSizes.contains(backdropSize);
    }

    public boolean isValidProfileSize(String profileSize) {
        if (StringUtils.isBlank((CharSequence)profileSize) || this.profileSizes.isEmpty()) {
            return false;
        }
        return this.profileSizes.contains(profileSize);
    }

    public boolean isValidLogoSize(String logoSize) {
        if (StringUtils.isBlank((CharSequence)logoSize) || this.logoSizes.isEmpty()) {
            return false;
        }
        return this.logoSizes.contains(logoSize);
    }

    public boolean isValidSize(String sizeToCheck) {
        return this.isValidPosterSize(sizeToCheck) || this.isValidBackdropSize(sizeToCheck) || this.isValidProfileSize(sizeToCheck) || this.isValidLogoSize(sizeToCheck);
    }
}

