/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.bs;

import com.github.houbb.heaven.support.handler.IHandler;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.sensitive.word.api.ISensitiveWordReplace;
import com.github.houbb.sensitive.word.api.IWordAllow;
import com.github.houbb.sensitive.word.api.IWordContext;
import com.github.houbb.sensitive.word.api.IWordDeny;
import com.github.houbb.sensitive.word.api.IWordMap;
import com.github.houbb.sensitive.word.api.IWordResult;
import com.github.houbb.sensitive.word.api.IWordResultHandler;
import com.github.houbb.sensitive.word.bs.SensitiveWordContext;
import com.github.houbb.sensitive.word.support.allow.WordAllows;
import com.github.houbb.sensitive.word.support.deny.WordDenys;
import com.github.houbb.sensitive.word.support.map.SensitiveWordMap;
import com.github.houbb.sensitive.word.support.replace.SensitiveWordReplaceChar;
import com.github.houbb.sensitive.word.support.result.WordResultHandlers;
import com.github.houbb.sensitive.word.utils.InnerFormatUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class SensitiveWordBs {
    private IWordMap sensitiveWordMap;
    private final IWordContext context = this.buildDefaultContext();
    private IWordDeny wordDeny = WordDenys.system();
    private IWordAllow wordAllow = WordAllows.system();

    private SensitiveWordBs() {
    }

    private synchronized void initWordMap() {
        List<String> denyList = this.wordDeny.deny();
        List<String> allowList = this.wordAllow.allow();
        List<String> results = this.getActualDenyList(denyList, allowList);
        if (this.sensitiveWordMap == null) {
            this.sensitiveWordMap = new SensitiveWordMap();
        }
        this.sensitiveWordMap.initWordMap(results);
    }

    List<String> getActualDenyList(List<String> denyList, List<String> allowList) {
        if (CollectionUtil.isEmpty(denyList)) {
            return Collections.emptyList();
        }
        if (CollectionUtil.isEmpty(allowList)) {
            return denyList;
        }
        List<String> formatDenyList = this.formatWordList(denyList);
        List<String> formatAllowList = this.formatWordList(allowList);
        ArrayList<String> resultList = new ArrayList<String>();
        HashSet<String> allowSet = new HashSet<String>(formatAllowList);
        for (String deny : formatDenyList) {
            if (allowSet.contains(deny)) continue;
            resultList.add(deny);
        }
        return resultList;
    }

    private List<String> formatWordList(List<String> list) {
        if (CollectionUtil.isEmpty(list)) {
            return list;
        }
        ArrayList<String> resultList = new ArrayList<String>(list.size());
        for (String word : list) {
            String formatWord = InnerFormatUtils.format(word, this.context);
            resultList.add(formatWord);
        }
        return resultList;
    }

    public static SensitiveWordBs newInstance() {
        return new SensitiveWordBs();
    }

    public SensitiveWordBs init() {
        this.initWordMap();
        return this;
    }

    public SensitiveWordBs wordDeny(IWordDeny wordDeny) {
        ArgUtil.notNull((Object)wordDeny, (String)"wordDeny");
        this.wordDeny = wordDeny;
        return this;
    }

    public SensitiveWordBs wordAllow(IWordAllow wordAllow) {
        ArgUtil.notNull((Object)wordAllow, (String)"wordAllow");
        this.wordAllow = wordAllow;
        return this;
    }

    public SensitiveWordBs enableNumCheck(boolean enableNumCheck) {
        this.context.sensitiveCheckNum(enableNumCheck);
        return this;
    }

    public SensitiveWordBs enableEmailCheck(boolean enableEmailCheck) {
        this.context.sensitiveCheckEmail(enableEmailCheck);
        return this;
    }

    public SensitiveWordBs enableUrlCheck(boolean enableUrlCheck) {
        this.context.sensitiveCheckUrl(enableUrlCheck);
        return this;
    }

    public SensitiveWordBs ignoreCase(boolean ignoreCase) {
        this.context.ignoreCase(ignoreCase);
        return this;
    }

    public SensitiveWordBs ignoreWidth(boolean ignoreWidth) {
        this.context.ignoreWidth(ignoreWidth);
        return this;
    }

    public SensitiveWordBs ignoreNumStyle(boolean ignoreNumStyle) {
        this.context.ignoreNumStyle(ignoreNumStyle);
        return this;
    }

    public SensitiveWordBs ignoreChineseStyle(boolean ignoreChineseStyle) {
        this.context.ignoreChineseStyle(ignoreChineseStyle);
        return this;
    }

    public SensitiveWordBs ignoreEnglishStyle(boolean ignoreEnglishStyle) {
        this.context.ignoreEnglishStyle(ignoreEnglishStyle);
        return this;
    }

    public SensitiveWordBs ignoreRepeat(boolean ignoreRepeat) {
        this.context.ignoreRepeat(ignoreRepeat);
        return this;
    }

    private IWordContext buildDefaultContext() {
        SensitiveWordContext wordContext = SensitiveWordContext.newInstance();
        wordContext.ignoreCase(true);
        wordContext.ignoreWidth(true);
        wordContext.ignoreNumStyle(true);
        wordContext.ignoreChineseStyle(true);
        wordContext.ignoreEnglishStyle(true);
        wordContext.ignoreRepeat(false);
        wordContext.sensitiveCheckNum(true);
        wordContext.sensitiveCheckEmail(true);
        wordContext.sensitiveCheckUrl(true);
        return wordContext;
    }

    public boolean contains(String target) {
        this.statusCheck();
        return this.sensitiveWordMap.contains(target, this.context);
    }

    public List<String> findAll(String target) {
        return this.findAll(target, WordResultHandlers.word());
    }

    public String findFirst(String target) {
        return this.findFirst(target, WordResultHandlers.word());
    }

    public <R> List<R> findAll(String target, final IWordResultHandler<R> handler) {
        ArgUtil.notNull(handler, (String)"handler");
        this.statusCheck();
        List<IWordResult> wordResults = this.sensitiveWordMap.findAll(target, this.context);
        return CollectionUtil.toList(wordResults, (IHandler)new IHandler<IWordResult, R>(){

            public R handle(IWordResult wordResult) {
                return handler.handle(wordResult);
            }
        });
    }

    public <R> R findFirst(String target, IWordResultHandler<R> handler) {
        ArgUtil.notNull(handler, (String)"handler");
        this.statusCheck();
        IWordResult wordResult = this.sensitiveWordMap.findFirst(target, this.context);
        return handler.handle(wordResult);
    }

    public String replace(String target, char replaceChar) {
        SensitiveWordReplaceChar replace = new SensitiveWordReplaceChar(replaceChar);
        return this.replace(target, replace);
    }

    public String replace(String target, ISensitiveWordReplace replace) {
        this.statusCheck();
        return this.sensitiveWordMap.replace(target, replace, this.context);
    }

    public String replace(String target) {
        return this.replace(target, '*');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statusCheck() {
        if (this.sensitiveWordMap == null) {
            SensitiveWordBs sensitiveWordBs = this;
            synchronized (sensitiveWordBs) {
                if (this.sensitiveWordMap == null) {
                    this.init();
                }
            }
        }
    }
}

