/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeffreyning.mybatisplus.handler;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.github.jeffreyning.mybatisplus.anno.InsertFill;
import com.github.jeffreyning.mybatisplus.anno.UpdateFill;
import com.github.jeffreyning.mybatisplus.util.PlusACUtils;
import com.github.jeffreyning.mybatisplus.util.ReadValueUtil;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.SqlSessionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.stereotype.Component;

@Component
public class DataAutoFill
implements MetaObjectHandler {
    private static final Logger logger = LoggerFactory.getLogger(DataAutoFill.class);

    public void insertFill(MetaObject metaObject) {
        Object classObj = metaObject.getOriginalObject();
        Field[] declaredFields = classObj.getClass().getDeclaredFields();
        if (declaredFields != null) {
            for (Field field : declaredFields) {
                InsertFill insertFill = field.getAnnotation(InsertFill.class);
                if (insertFill == null) continue;
                String fieldName = field.getName();
                String sql = insertFill.value();
                if (sql == null || "".equals(sql)) continue;
                SqlSessionTemplate sqlSessionTemplate = PlusACUtils.getBean(SqlSessionTemplate.class);
                SqlSession sqlSession = null;
                try {
                    sqlSession = SqlSessionUtils.getSqlSession((SqlSessionFactory)sqlSessionTemplate.getSqlSessionFactory(), (ExecutorType)sqlSessionTemplate.getExecutorType(), (PersistenceExceptionTranslator)sqlSessionTemplate.getPersistenceExceptionTranslator());
                    ResultSet resultSet = sqlSession.getConnection().createStatement().executeQuery(sql);
                    if (resultSet == null || !resultSet.next()) continue;
                    Class<?> fieldType = field.getType();
                    Object fieldVal = ReadValueUtil.readValue(resultSet, fieldType);
                    this.fillStrategy(metaObject, fieldName, fieldVal);
                }
                catch (SQLException e) {
                    logger.error("insert fill error", (Throwable)e);
                    throw new RuntimeException("insert fill error", e);
                }
                finally {
                    if (sqlSession != null) {
                        SqlSessionUtils.closeSqlSession((SqlSession)sqlSession, (SqlSessionFactory)sqlSessionTemplate.getSqlSessionFactory());
                    }
                }
            }
        }
    }

    public void updateFill(MetaObject metaObject) {
        Object classObj = metaObject.getOriginalObject();
        Field[] declaredFields = classObj.getClass().getDeclaredFields();
        if (declaredFields != null) {
            for (Field field : declaredFields) {
                UpdateFill updateFill = field.getAnnotation(UpdateFill.class);
                if (updateFill == null) continue;
                String fieldName = field.getName();
                String sql = updateFill.value();
                if (sql == null || "".equals(sql)) continue;
                SqlSessionTemplate sqlSessionTemplate = PlusACUtils.getBean(SqlSessionTemplate.class);
                SqlSession sqlSession = null;
                try {
                    sqlSession = SqlSessionUtils.getSqlSession((SqlSessionFactory)sqlSessionTemplate.getSqlSessionFactory(), (ExecutorType)sqlSessionTemplate.getExecutorType(), (PersistenceExceptionTranslator)sqlSessionTemplate.getPersistenceExceptionTranslator());
                    ResultSet resultSet = sqlSession.getConnection().createStatement().executeQuery(sql);
                    if (resultSet == null || !resultSet.next()) continue;
                    Class<?> fieldType = field.getType();
                    Object fieldVal = ReadValueUtil.readValue(resultSet, fieldType);
                    this.fillStrategy(metaObject, fieldName, fieldVal);
                }
                catch (SQLException e) {
                    logger.error("update fill error", (Throwable)e);
                    throw new RuntimeException("update fill error", e);
                }
                finally {
                    if (sqlSession != null) {
                        SqlSessionUtils.closeSqlSession((SqlSession)sqlSession, (SqlSessionFactory)sqlSessionTemplate.getSqlSessionFactory());
                    }
                }
            }
        }
    }
}

