/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.interceptor;

import com.github.lianjiatech.retrofit.spring.boot.interceptor.BaseLoggingInterceptor;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class DefaultLoggingInterceptor
extends BaseLoggingInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultLoggingInterceptor.class);
    private final HttpLoggingInterceptor httpLoggingInterceptor;

    public DefaultLoggingInterceptor(Level logLevel, BaseLoggingInterceptor.LogStrategy logStrategy) {
        super(logLevel, logStrategy);
        HttpLoggingInterceptor.Logger logger = this.httpLoggingInterceptorLogger(logLevel);
        this.httpLoggingInterceptor = new HttpLoggingInterceptor(logger);
        String name = logStrategy.name();
        HttpLoggingInterceptor.Level level = HttpLoggingInterceptor.Level.valueOf((String)name);
        this.httpLoggingInterceptor.setLevel(level);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return this.httpLoggingInterceptor.intercept(chain);
    }

    public HttpLoggingInterceptor.Logger httpLoggingInterceptorLogger(Level level) {
        if (level == Level.DEBUG) {
            return arg_0 -> ((Logger)logger).debug(arg_0);
        }
        if (level == Level.ERROR) {
            return arg_0 -> ((Logger)logger).error(arg_0);
        }
        if (level == Level.INFO) {
            return arg_0 -> ((Logger)logger).info(arg_0);
        }
        if (level == Level.TRACE) {
            return arg_0 -> ((Logger)logger).trace(arg_0);
        }
        if (level == Level.WARN) {
            return arg_0 -> ((Logger)logger).warn(arg_0);
        }
        throw new UnsupportedOperationException("We don't support this log level currently.");
    }
}

