/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.interceptor;

import com.github.lianjiatech.retrofit.spring.boot.interceptor.BaseHttpExceptionMessageFormatter;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HttpExceptionMessageFormatterInterceptor
implements Interceptor {
    private final BaseHttpExceptionMessageFormatter httpExceptionMessageFormatter;

    public HttpExceptionMessageFormatterInterceptor(BaseHttpExceptionMessageFormatter httpExceptionMessageFormatter) {
        this.httpExceptionMessageFormatter = httpExceptionMessageFormatter;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = null;
        Response response = null;
        try {
            request = chain.request();
            response = chain.proceed(request);
        }
        catch (IOException e) {
            String alarmFormat = this.httpExceptionMessageFormatter.alarmFormat(request, response);
            String message = e.getMessage() + "\n" + alarmFormat;
            throw new IOException(message, e);
        }
        catch (Exception e) {
            String alarmFormat = this.httpExceptionMessageFormatter.alarmFormat(request, response);
            String message = e.getMessage() + "\n" + alarmFormat;
            throw new RuntimeException(message, e);
        }
        return response;
    }
}

