/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core;

import com.github.lianjiatech.retrofit.spring.boot.exception.RetrofitException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import okhttp3.Request;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.Retrofit;

public final class BodyCallAdapterFactory
extends CallAdapter.Factory {
    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        if (Call.class.isAssignableFrom(BodyCallAdapterFactory.getRawType((Type)returnType))) {
            return null;
        }
        if (CompletableFuture.class.isAssignableFrom(BodyCallAdapterFactory.getRawType((Type)returnType))) {
            return null;
        }
        if (Response.class.isAssignableFrom(BodyCallAdapterFactory.getRawType((Type)returnType))) {
            return null;
        }
        return new BodyCallAdapter(returnType);
    }

    final class BodyCallAdapter<R>
    implements CallAdapter<R, R> {
        private Type returnType;

        BodyCallAdapter(Type returnType) {
            this.returnType = returnType;
        }

        public Type responseType() {
            return this.returnType;
        }

        public R adapt(Call<R> call) {
            Response response;
            Request request = call.request();
            try {
                response = call.execute();
            }
            catch (IOException e) {
                throw Objects.requireNonNull(RetrofitException.errorExecuting(request, e));
            }
            return (R)response.body();
        }
    }
}

