/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core;

import com.github.lianjiatech.retrofit.spring.boot.annotation.InterceptMark;
import com.github.lianjiatech.retrofit.spring.boot.annotation.OkHttpClientBuilder;
import com.github.lianjiatech.retrofit.spring.boot.annotation.RetrofitClient;
import com.github.lianjiatech.retrofit.spring.boot.config.RetrofitConfigBean;
import com.github.lianjiatech.retrofit.spring.boot.config.RetrofitProperties;
import com.github.lianjiatech.retrofit.spring.boot.core.ErrorDecoder;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.BaseGlobalInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.BaseLoggingInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.BasePathMatchInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.ErrorDecoderInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.LogStrategy;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.NetworkInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.ServiceInstanceChooserInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.retry.BaseRetryInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.util.BeanExtendUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.event.Level;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class RetrofitFactoryBean<T>
implements FactoryBean<T>,
EnvironmentAware,
ApplicationContextAware {
    public static final String SUFFIX = "/";
    private Class<T> retrofitInterface;
    private Environment environment;
    private RetrofitProperties retrofitProperties;
    private RetrofitConfigBean retrofitConfigBean;
    private ApplicationContext applicationContext;

    public RetrofitFactoryBean(Class<T> retrofitInterface) {
        this.retrofitInterface = retrofitInterface;
    }

    public T getObject() throws Exception {
        this.checkRetrofitInterface(this.retrofitInterface);
        Retrofit retrofit = this.getRetrofit(this.retrofitInterface);
        return (T)retrofit.create(this.retrofitInterface);
    }

    private void checkRetrofitInterface(Class<T> retrofitInterface) {
        Assert.isTrue((boolean)retrofitInterface.isInterface(), (String)"@RetrofitClient can only be marked on the interface type!");
        Method[] methods = retrofitInterface.getMethods();
        RetrofitClient retrofitClient = retrofitInterface.getAnnotation(RetrofitClient.class);
        Assert.isTrue((StringUtils.hasText((String)retrofitClient.baseUrl()) || StringUtils.hasText((String)retrofitClient.path()) ? 1 : 0) != 0, (String)"@RetrofitClient's baseUrl and serviceId must be configured with one\uff01");
        for (Method method : methods) {
            Class<?> returnType = method.getReturnType();
            if (method.isAnnotationPresent(OkHttpClientBuilder.class)) {
                Assert.isTrue((boolean)returnType.equals(OkHttpClient.Builder.class), (String)"For methods annotated by @OkHttpClientBuilder, the return value must be OkHttpClient.Builder\uff01");
                Assert.isTrue((boolean)Modifier.isStatic(method.getModifiers()), (String)"only static method can annotated by @OkHttpClientBuilder!");
                continue;
            }
            Assert.isTrue((!Void.TYPE.isAssignableFrom(returnType) ? 1 : 0) != 0, (String)("The void keyword is not supported as the return type, please use java.lang.Void\uff01 method=" + method));
            if (!this.retrofitProperties.isDisableVoidReturnType()) continue;
            Assert.isTrue((!Void.class.isAssignableFrom(returnType) ? 1 : 0) != 0, (String)("Configured to disable Void as the return value, please specify another return type!method=" + method));
        }
    }

    public Class<T> getObjectType() {
        return this.retrofitInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    private synchronized ConnectionPool getConnectionPool(Class<?> retrofitClientInterfaceClass) {
        RetrofitClient retrofitClient = retrofitClientInterfaceClass.getAnnotation(RetrofitClient.class);
        String poolName = retrofitClient.poolName();
        Map<String, ConnectionPool> poolRegistry = this.retrofitConfigBean.getPoolRegistry();
        Assert.notNull(poolRegistry, (String)"poolRegistry does not exist! Please set retrofitConfigBean.poolRegistry!");
        ConnectionPool connectionPool = poolRegistry.get(poolName);
        Assert.notNull((Object)connectionPool, (String)("The connection pool corresponding to the current poolName does not exist! poolName = " + poolName));
        return connectionPool;
    }

    private synchronized OkHttpClient getOkHttpClient(Class<?> retrofitClientInterfaceClass) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Collection<NetworkInterceptor> networkInterceptors;
        Class<? extends ErrorDecoder> errorDecoderClass;
        ErrorDecoder decoder;
        ServiceInstanceChooserInterceptor serviceInstanceChooserInterceptor;
        OkHttpClient.Builder okHttpClientBuilder;
        RetrofitClient retrofitClient = retrofitClientInterfaceClass.getAnnotation(RetrofitClient.class);
        Method method = this.findOkHttpClientBuilderMethod(retrofitClientInterfaceClass);
        if (method != null) {
            okHttpClientBuilder = (OkHttpClient.Builder)method.invoke(null, new Object[0]);
        } else {
            ConnectionPool connectionPool = this.getConnectionPool(retrofitClientInterfaceClass);
            okHttpClientBuilder = new OkHttpClient.Builder().connectTimeout((long)retrofitClient.connectTimeoutMs(), TimeUnit.MILLISECONDS).readTimeout((long)retrofitClient.readTimeoutMs(), TimeUnit.MILLISECONDS).writeTimeout((long)retrofitClient.writeTimeoutMs(), TimeUnit.MILLISECONDS).callTimeout((long)retrofitClient.callTimeoutMs(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(retrofitClient.retryOnConnectionFailure()).followRedirects(retrofitClient.followRedirects()).followSslRedirects(retrofitClient.followSslRedirects()).pingInterval((long)retrofitClient.pingIntervalMs(), TimeUnit.MILLISECONDS).connectionPool(connectionPool);
        }
        if (StringUtils.hasText((String)retrofitClient.serviceId()) && (serviceInstanceChooserInterceptor = this.retrofitConfigBean.getServiceInstanceChooserInterceptor()) != null) {
            okHttpClientBuilder.addInterceptor((Interceptor)serviceInstanceChooserInterceptor);
        }
        if ((decoder = this.getBean(errorDecoderClass = retrofitClient.errorDecoder())) == null) {
            decoder = errorDecoderClass.newInstance();
        }
        ErrorDecoderInterceptor decoderInterceptor = ErrorDecoderInterceptor.create(decoder);
        okHttpClientBuilder.addInterceptor((Interceptor)decoderInterceptor);
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>(this.findInterceptorByAnnotation(retrofitClientInterfaceClass));
        Collection<BaseGlobalInterceptor> globalInterceptors = this.retrofitConfigBean.getGlobalInterceptors();
        if (!CollectionUtils.isEmpty(globalInterceptors)) {
            interceptors.addAll(globalInterceptors);
        }
        interceptors.forEach(arg_0 -> ((OkHttpClient.Builder)okHttpClientBuilder).addInterceptor(arg_0));
        BaseRetryInterceptor retryInterceptor = this.retrofitConfigBean.getRetryInterceptor();
        okHttpClientBuilder.addInterceptor((Interceptor)retryInterceptor);
        if (this.retrofitProperties.isEnableLog() && retrofitClient.enableLog()) {
            Class<? extends BaseLoggingInterceptor> loggingInterceptorClass = this.retrofitProperties.getLoggingInterceptor();
            Constructor<? extends BaseLoggingInterceptor> constructor = loggingInterceptorClass.getConstructor(Level.class, LogStrategy.class);
            BaseLoggingInterceptor loggingInterceptor = constructor.newInstance(new Object[]{retrofitClient.logLevel(), retrofitClient.logStrategy()});
            okHttpClientBuilder.addNetworkInterceptor((Interceptor)loggingInterceptor);
        }
        if (!CollectionUtils.isEmpty(networkInterceptors = this.retrofitConfigBean.getNetworkInterceptors())) {
            for (NetworkInterceptor networkInterceptor : networkInterceptors) {
                okHttpClientBuilder.addNetworkInterceptor((Interceptor)networkInterceptor);
            }
        }
        return okHttpClientBuilder.build();
    }

    private <U> U getBean(Class<U> clz) {
        try {
            Object bean = this.applicationContext.getBean(clz);
            return (U)bean;
        }
        catch (BeansException e) {
            return null;
        }
    }

    private Method findOkHttpClientBuilderMethod(Class<?> retrofitClientInterfaceClass) {
        Method[] methods;
        for (Method method : methods = retrofitClientInterfaceClass.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !method.isAnnotationPresent(OkHttpClientBuilder.class) || !method.getReturnType().equals(OkHttpClient.Builder.class)) continue;
            return method;
        }
        return null;
    }

    private List<Interceptor> findInterceptorByAnnotation(Class<?> retrofitClientInterfaceClass) throws InstantiationException, IllegalAccessException {
        Annotation[] classAnnotations = retrofitClientInterfaceClass.getAnnotations();
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        ArrayList<Annotation> interceptAnnotations = new ArrayList<Annotation>();
        for (Annotation classAnnotation : classAnnotations) {
            Class<? extends Annotation> annotationType = classAnnotation.annotationType();
            if (!annotationType.isAnnotationPresent(InterceptMark.class)) continue;
            interceptAnnotations.add(classAnnotation);
        }
        for (Annotation interceptAnnotation : interceptAnnotations) {
            Map annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)interceptAnnotation);
            Object handler = annotationAttributes.get("handler");
            Assert.notNull(handler, (String)"@InterceptMark annotations must be configured: Class<? extends BasePathMatchInterceptor> handler()");
            Assert.notNull(annotationAttributes.get("include"), (String)"@InterceptMark annotations must be configured: String[] include()");
            Assert.notNull(annotationAttributes.get("exclude"), (String)"@InterceptMark annotations must be configured: String[] exclude()");
            Class interceptorClass = (Class)handler;
            BasePathMatchInterceptor interceptor = this.getInterceptorInstance(interceptorClass);
            HashMap annotationResolveAttributes = new HashMap(8);
            annotationAttributes.forEach((key, value) -> {
                if (value instanceof String) {
                    String newValue = this.environment.resolvePlaceholders((String)value);
                    annotationResolveAttributes.put(key, newValue);
                } else {
                    annotationResolveAttributes.put(key, value);
                }
            });
            BeanExtendUtils.populate(interceptor, annotationResolveAttributes);
            interceptors.add(interceptor);
        }
        return interceptors;
    }

    private BasePathMatchInterceptor getInterceptorInstance(Class<? extends BasePathMatchInterceptor> interceptorClass) throws IllegalAccessException, InstantiationException {
        try {
            return (BasePathMatchInterceptor)this.applicationContext.getBean(interceptorClass);
        }
        catch (BeansException e) {
            return interceptorClass.newInstance();
        }
    }

    private synchronized Retrofit getRetrofit(Class<?> retrofitClientInterfaceClass) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        List<Converter.Factory> converterFactories;
        RetrofitClient retrofitClient = retrofitClientInterfaceClass.getAnnotation(RetrofitClient.class);
        String baseUrl = retrofitClient.baseUrl();
        if (StringUtils.hasText((String)baseUrl)) {
            if (!(baseUrl = this.environment.resolveRequiredPlaceholders(baseUrl)).endsWith(SUFFIX)) {
                baseUrl = baseUrl + SUFFIX;
            }
        } else {
            String serviceId = retrofitClient.serviceId();
            String path = retrofitClient.path();
            if (!path.endsWith(SUFFIX)) {
                path = path + SUFFIX;
            }
            baseUrl = "http://" + (serviceId + SUFFIX + path).replaceAll("/+", SUFFIX);
            baseUrl = this.environment.resolveRequiredPlaceholders(baseUrl);
        }
        OkHttpClient client = this.getOkHttpClient(retrofitClientInterfaceClass);
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(baseUrl).validateEagerly(retrofitClient.validateEagerly()).client(client);
        List<CallAdapter.Factory> callAdapterFactories = this.retrofitConfigBean.getCallAdapterFactories();
        if (!CollectionUtils.isEmpty(callAdapterFactories)) {
            callAdapterFactories.forEach(arg_0 -> ((Retrofit.Builder)retrofitBuilder).addCallAdapterFactory(arg_0));
        }
        if (!CollectionUtils.isEmpty(converterFactories = this.retrofitConfigBean.getConverterFactories())) {
            converterFactories.forEach(arg_0 -> ((Retrofit.Builder)retrofitBuilder).addConverterFactory(arg_0));
        }
        return retrofitBuilder.build();
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.retrofitConfigBean = (RetrofitConfigBean)applicationContext.getBean(RetrofitConfigBean.class);
        this.retrofitProperties = this.retrofitConfigBean.getRetrofitProperties();
    }
}

