/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.degrade;

import com.github.lianjiatech.retrofit.spring.boot.degrade.BaseResourceNameParser;
import com.github.lianjiatech.retrofit.spring.boot.degrade.RetrofitBlockException;
import java.io.IOException;
import java.lang.reflect.Method;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.springframework.core.env.Environment;
import retrofit2.Invocation;

public abstract class BaseDegradeInterceptor
implements Interceptor {
    private Environment environment;
    private BaseResourceNameParser resourceNameParser;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceNameParser(BaseResourceNameParser resourceNameParser) {
        this.resourceNameParser = resourceNameParser;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Invocation invocation = (Invocation)request.tag(Invocation.class);
        assert (invocation != null);
        Method method = invocation.method();
        String resourceName = this.resourceNameParser.parseResourceName(method, this.environment);
        return this.degradeIntercept(resourceName, chain);
    }

    protected abstract Response degradeIntercept(String var1, Interceptor.Chain var2) throws RetrofitBlockException, IOException;
}

