/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core;

import com.github.lianjiatech.retrofit.spring.boot.exception.RetrofitException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import okhttp3.Request;
import org.springframework.util.Assert;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.Retrofit;

public final class ResponseCallAdapterFactory
extends CallAdapter.Factory {
    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        if (Response.class.isAssignableFrom(ResponseCallAdapterFactory.getRawType((Type)returnType))) {
            return new ResponseCallAdapter(returnType);
        }
        return null;
    }

    final class ResponseCallAdapter<R>
    implements CallAdapter<R, Response<R>> {
        private Type returnType;

        ResponseCallAdapter(Type returnType) {
            this.returnType = returnType;
        }

        public Type responseType() {
            ParameterizedType parameterizedType = (ParameterizedType)this.returnType;
            Object[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            Assert.notEmpty((Object[])actualTypeArguments, (String)"Response must specify generic parameters!");
            return actualTypeArguments[0];
        }

        public Response<R> adapt(Call<R> call) {
            Request request = call.request();
            try {
                return call.execute();
            }
            catch (IOException e) {
                throw Objects.requireNonNull(RetrofitException.errorExecuting(request, e));
            }
        }
    }
}

