/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core;

import com.github.lianjiatech.retrofit.spring.boot.config.DegradeProperty;
import com.github.lianjiatech.retrofit.spring.boot.config.RetrofitProperties;
import com.github.lianjiatech.retrofit.spring.boot.degrade.FallbackFactory;
import com.github.lianjiatech.retrofit.spring.boot.degrade.RetrofitBlockException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class RetrofitInvocationHandler
implements InvocationHandler {
    private final Object source;
    private final DegradeProperty degradeProperty;
    private Object fallback;
    private FallbackFactory<?> fallbackFactory;

    public RetrofitInvocationHandler(Object source, Object fallback, FallbackFactory<?> fallbackFactory, RetrofitProperties retrofitProperties) {
        this.source = source;
        this.degradeProperty = retrofitProperties.getDegrade();
        this.fallback = fallback;
        this.fallbackFactory = fallbackFactory;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.source, args);
        }
        catch (Throwable e) {
            Object fallbackObject;
            Throwable cause = e.getCause();
            if (cause instanceof RetrofitBlockException && this.degradeProperty.isEnable() && (fallbackObject = this.getFallbackObject(cause)) != null) {
                return method.invoke(fallbackObject, args);
            }
            throw cause;
        }
    }

    private Object getFallbackObject(Throwable cause) {
        if (this.fallback != null) {
            return this.fallback;
        }
        if (this.fallbackFactory != null) {
            return this.fallbackFactory.create(cause);
        }
        return null;
    }
}

