/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core;

import com.github.lianjiatech.retrofit.spring.boot.core.ServiceInstanceChooser;
import java.net.URI;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.util.Assert;

public class SpringCloudServiceInstanceChooser
implements ServiceInstanceChooser {
    private final LoadBalancerClient loadBalancerClient;

    public SpringCloudServiceInstanceChooser(LoadBalancerClient loadBalancerClient) {
        this.loadBalancerClient = loadBalancerClient;
    }

    @Override
    public URI choose(String serviceId) {
        ServiceInstance serviceInstance = this.loadBalancerClient.choose(serviceId);
        Assert.notNull((Object)serviceInstance, (String)("can not found service instance! serviceId=" + serviceId));
        return serviceInstance.getUri();
    }
}

