/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.interceptor;

import com.github.lianjiatech.retrofit.spring.boot.interceptor.PrototypeInterceptor;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public abstract class BasePathMatchInterceptor
implements PrototypeInterceptor {
    private String[] include;
    private String[] exclude;
    private PathMatcher pathMatcher = new AntPathMatcher();

    public void setInclude(String[] include) {
        this.include = include;
    }

    public void setExclude(String[] exclude) {
        this.exclude = exclude;
    }

    public final Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String path = request.url().encodedPath();
        if (this.isMatch(this.exclude, path)) {
            return chain.proceed(request);
        }
        if (!this.isMatch(this.include, path)) {
            return chain.proceed(request);
        }
        return this.doIntercept(chain);
    }

    protected abstract Response doIntercept(Interceptor.Chain var1) throws IOException;

    private boolean isMatch(String[] patterns, String path) {
        if (patterns == null || patterns.length == 0) {
            return false;
        }
        for (String pattern : patterns) {
            boolean match = this.pathMatcher.match(pattern, path);
            if (!match) continue;
            return true;
        }
        return false;
    }
}

