/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.retry;

import com.github.lianjiatech.retrofit.spring.boot.retry.Retry;
import com.github.lianjiatech.retrofit.spring.boot.retry.RetryRule;
import java.io.IOException;
import java.lang.reflect.Method;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Invocation;

public abstract class BaseRetryInterceptor
implements Interceptor {
    private boolean enableGlobalRetry;
    private int globalMaxRetries;
    private int globalIntervalMs;
    private RetryRule[] globalRetryRules;
    private static final int LIMIT_RETRIES = 100;

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Invocation invocation = (Invocation)request.tag(Invocation.class);
        assert (invocation != null);
        Method method = invocation.method();
        Retry retry = this.getRetry(method);
        if (!this.needRetry(retry)) {
            return chain.proceed(request);
        }
        int maxRetries = retry == null ? this.globalMaxRetries : retry.maxRetries();
        int intervalMs = retry == null ? this.globalIntervalMs : retry.intervalMs();
        RetryRule[] retryRules = retry == null ? this.globalRetryRules : retry.retryRules();
        maxRetries = Math.min(maxRetries, 100);
        return this.retryIntercept(maxRetries, intervalMs, retryRules, chain);
    }

    private boolean needRetry(Retry retry) {
        if (this.enableGlobalRetry) {
            if (retry == null) {
                return true;
            }
            if (retry.enable()) {
                return true;
            }
        } else if (retry != null && retry.enable()) {
            return true;
        }
        return false;
    }

    private Retry getRetry(Method method) {
        Retry retry;
        if (method.isAnnotationPresent(Retry.class)) {
            retry = method.getAnnotation(Retry.class);
        } else {
            Class<?> declaringClass = method.getDeclaringClass();
            retry = declaringClass.getAnnotation(Retry.class);
        }
        return retry;
    }

    protected abstract Response retryIntercept(int var1, int var2, RetryRule[] var3, Interceptor.Chain var4);

    public void setEnableGlobalRetry(boolean enableGlobalRetry) {
        this.enableGlobalRetry = enableGlobalRetry;
    }

    public void setGlobalMaxRetries(int globalMaxRetries) {
        this.globalMaxRetries = globalMaxRetries;
    }

    public void setGlobalIntervalMs(int globalIntervalMs) {
        this.globalIntervalMs = globalIntervalMs;
    }

    public void setGlobalRetryRules(RetryRule[] globalRetryRules) {
        this.globalRetryRules = globalRetryRules;
    }
}

