/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core.reactive;

import com.github.lianjiatech.retrofit.spring.boot.core.InternalCallAdapterFactory;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.HttpException;
import retrofit2.Response;
import retrofit2.Retrofit;

public class Rxjava2SingleCallAdapterFactory
extends CallAdapter.Factory
implements InternalCallAdapterFactory {
    public static final Rxjava2SingleCallAdapterFactory INSTANCE = new Rxjava2SingleCallAdapterFactory();

    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        if (Rxjava2SingleCallAdapterFactory.getRawType((Type)returnType) != Single.class) {
            return null;
        }
        if (!(returnType instanceof ParameterizedType)) {
            throw new IllegalStateException("Mono return type must be parameterized as Single<Foo> or Single<? extends Foo>");
        }
        Type innerType = Rxjava2SingleCallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)returnType));
        if (Rxjava2SingleCallAdapterFactory.getRawType((Type)innerType) != Response.class) {
            return new BodyCallAdapter(innerType);
        }
        if (!(innerType instanceof ParameterizedType)) {
            throw new IllegalStateException("Response must be parameterized as Response<Foo> or Response<? extends Foo>");
        }
        Type responseType = Rxjava2SingleCallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)innerType));
        return new ResponseCallAdapter(responseType);
    }

    private Rxjava2SingleCallAdapterFactory() {
    }

    private class ResponseCallAdapter<R>
    implements CallAdapter<R, Single<Response<R>>> {
        private final Type responseType;

        public ResponseCallAdapter(Type responseType) {
            this.responseType = responseType;
        }

        public Type responseType() {
            return this.responseType;
        }

        public Single<Response<R>> adapt(Call<R> call) {
            return Single.create(emitter -> call.enqueue((Callback)new ResponseCallBack(emitter)));
        }

        private class ResponseCallBack
        implements Callback<R> {
            private final SingleEmitter<Response<R>> emitter;

            public ResponseCallBack(SingleEmitter<Response<R>> emitter) {
                this.emitter = emitter;
            }

            public void onResponse(Call<R> call, Response<R> response) {
                this.emitter.onSuccess(response);
            }

            public void onFailure(Call<R> call, Throwable t) {
                this.emitter.onError(t);
            }
        }
    }

    private class BodyCallAdapter<R>
    implements CallAdapter<R, Single<R>> {
        private final Type responseType;

        public BodyCallAdapter(Type responseType) {
            this.responseType = responseType;
        }

        public Type responseType() {
            return this.responseType;
        }

        public Single<R> adapt(Call<R> call) {
            return Single.create(emitter -> call.enqueue((Callback)new BodyCallBack(emitter)));
        }

        private class BodyCallBack
        implements Callback<R> {
            private final SingleEmitter<R> emitter;

            public BodyCallBack(SingleEmitter<R> emitter) {
                this.emitter = emitter;
            }

            public void onResponse(Call<R> call, Response<R> response) {
                if (response.isSuccessful()) {
                    this.emitter.onSuccess(response.body());
                } else {
                    this.emitter.onError((Throwable)new HttpException(response));
                }
            }

            public void onFailure(Call<R> call, Throwable t) {
                this.emitter.onError(t);
            }
        }
    }
}

