/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.interceptor;

import com.github.lianjiatech.retrofit.spring.boot.core.RetrofitClient;
import com.github.lianjiatech.retrofit.spring.boot.core.ServiceInstanceChooser;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.net.URI;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.StringUtils;
import retrofit2.Invocation;

public class ServiceChooseInterceptor
implements Interceptor {
    protected final ServiceInstanceChooser serviceInstanceChooser;

    public ServiceChooseInterceptor(ServiceInstanceChooser serviceDiscovery) {
        this.serviceInstanceChooser = serviceDiscovery;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Invocation invocation = (Invocation)request.tag(Invocation.class);
        if (invocation == null) {
            return chain.proceed(request);
        }
        RetrofitClient retrofitClient = (RetrofitClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)invocation.service(), RetrofitClient.class);
        String baseUrl = retrofitClient.baseUrl();
        if (StringUtils.hasText((String)baseUrl)) {
            return chain.proceed(request);
        }
        String serviceId = retrofitClient.serviceId();
        URI uri = this.serviceInstanceChooser.choose(serviceId);
        HttpUrl url = request.url();
        int port = uri.getPort();
        String scheme = uri.getScheme();
        if (port <= 0 || port > 65535) {
            port = HttpUrl.defaultPort((String)scheme);
        }
        HttpUrl newUrl = url.newBuilder().scheme(scheme).host(uri.getHost()).port(port).build();
        Request newReq = request.newBuilder().url(newUrl).build();
        return chain.proceed(newReq);
    }
}

