/*
 * Decompiled with CFR 0.152.
 */
package org.savarese.vserv.tcpip;

import org.savarese.vserv.tcpip.IPPacket;

public abstract class ICMPPacket
extends IPPacket {
    public static final int OFFSET_TYPE = 0;
    public static final int OFFSET_CODE = 1;
    public static final int OFFSET_ICMP_CHECKSUM = 2;
    public static final int OFFSET_IDENTIFIER = 4;
    public static final int OFFSET_SEQUENCE = 6;
    public static final int TYPE_ECHO_REQUEST = 8;
    public static final int TYPE_ECHO_REPLY = 0;
    int _offset;

    public ICMPPacket(int size) {
        super(size);
        this._offset = 0;
    }

    public ICMPPacket(ICMPPacket packet) {
        super(packet.size());
        this.copy(packet);
        this._offset = packet._offset;
    }

    public abstract int getICMPHeaderByteLength();

    @Override
    public void setIPHeaderLength(int length) {
        super.setIPHeaderLength(length);
        this._offset = this.getIPHeaderByteLength();
    }

    public final int getCombinedHeaderByteLength() {
        return this._offset + this.getICMPHeaderByteLength();
    }

    public final int getICMPDataByteLength() {
        return this.getIPPacketLength() - this.getCombinedHeaderByteLength();
    }

    public final void setICMPDataByteLength(int length) {
        if (length < 0) {
            length = 0;
        }
        this.setIPPacketLength(this.getCombinedHeaderByteLength() + length);
    }

    public final int getICMPPacketByteLength() {
        return this.getIPPacketLength() - this._offset;
    }

    public final void copyData(ICMPPacket packet) {
        if (this._data_.length < packet._data_.length) {
            byte[] data = new byte[packet._data_.length];
            System.arraycopy(this._data_, 0, data, 0, this.getCombinedHeaderByteLength());
            this._data_ = data;
        }
        int length = packet.getICMPDataByteLength();
        System.arraycopy(packet._data_, packet.getCombinedHeaderByteLength(), this._data_, this.getCombinedHeaderByteLength(), length);
        this.setICMPDataByteLength(length);
    }

    @Override
    public void setData(byte[] data) {
        super.setData(data);
        this._offset = this.getIPHeaderByteLength();
    }

    public final int getType() {
        return this._data_[this._offset + 0] & 0xFF;
    }

    public final void setType(int type) {
        this._data_[this._offset + 0] = (byte)(type & 0xFF);
    }

    public final int getCode() {
        return this._data_[this._offset + 1] & 0xFF;
    }

    public final void setCode(int code) {
        this._data_[this._offset + 1] = (byte)(code & 0xFF);
    }

    public final int getICMPChecksum() {
        return (this._data_[this._offset + 2] & 0xFF) << 8 | this._data_[this._offset + 2 + 1] & 0xFF;
    }

    public final int computeICMPChecksum(boolean update) {
        return this._computeChecksum_(this._offset, this._offset + 2, this.getIPPacketLength(), 0, update);
    }

    public final int computeICMPChecksum() {
        return this.computeICMPChecksum(true);
    }
}

