/*
 * Decompiled with CFR 0.152.
 */
package org.savarese.vserv.tcpip;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.savarese.vserv.tcpip.OctetConverter;

public class IPPacket {
    public static final int OFFSET_TYPE_OF_SERVICE = 1;
    public static final int OFFSET_TOTAL_LENGTH = 2;
    public static final int OFFSET_IDENTIFICATION = 4;
    public static final int OFFSET_FLAGS = 6;
    public static final int OFFSET_SOURCE_ADDRESS = 12;
    public static final int LENGTH_SOURCE_ADDRESS = 4;
    public static final int OFFSET_DESTINATION_ADDRESS = 16;
    public static final int LENGTH_DESTINATION_ADDRESS = 4;
    public static final int OFFSET_TTL = 8;
    public static final int OFFSET_PROTOCOL = 9;
    public static final int OFFSET_IP_CHECKSUM = 10;
    public static final int PROTOCOL_IP = 0;
    public static final int PROTOCOL_ICMP = 1;
    public static final int PROTOCOL_TCP = 6;
    public static final int PROTOCOL_UDP = 17;
    protected byte[] _data_;

    public IPPacket(int size) {
        this.setData(new byte[size]);
    }

    public int size() {
        return this._data_.length;
    }

    public void setData(byte[] data) {
        this._data_ = data;
    }

    public void getData(byte[] data) {
        System.arraycopy(this._data_, 0, data, 0, data.length);
    }

    public final void copy(IPPacket packet) {
        if (this._data_.length != packet.size()) {
            this.setData(new byte[packet.size()]);
        }
        System.arraycopy(packet._data_, 0, this._data_, 0, this._data_.length);
    }

    public final int getIPVersion() {
        return (this._data_[0] & 0xF0) >> 4;
    }

    public final void setIPVersion(int version) {
        this._data_[0] = (byte)(this._data_[0] & 0xF);
        this._data_[0] = (byte)(this._data_[0] | version << 4 & 0xF0);
    }

    public final int getIPHeaderLength() {
        return this._data_[0] & 0xF;
    }

    public void setIPHeaderLength(int length) {
        this._data_[0] = (byte)(this._data_[0] & 0xF0);
        this._data_[0] = (byte)(this._data_[0] | length & 0xF);
    }

    public final int getIPHeaderByteLength() {
        return this.getIPHeaderLength() << 2;
    }

    public final int getTypeOfService() {
        return this._data_[1] & 0xFF;
    }

    public final void setTypeOfService(int service) {
        this._data_[1] = (byte)(service & 0xFF);
    }

    public final int getIPPacketLength() {
        return (this._data_[2] & 0xFF) << 8 | this._data_[3] & 0xFF;
    }

    public final void setIPPacketLength(int length) {
        this._data_[2] = (byte)(length >> 8 & 0xFF);
        this._data_[3] = (byte)(length & 0xFF);
    }

    public final int getIdentification() {
        return (this._data_[4] & 0xFF) << 8 | this._data_[5] & 0xFF;
    }

    public void setIdentification(int id) {
        this._data_[4] = (byte)(id >> 8 & 0xFF);
        this._data_[5] = (byte)(id & 0xFF);
    }

    public final int getIPFlags() {
        return (this._data_[6] & 0xE0) >> 5;
    }

    public final void setIPFlags(int flags) {
        this._data_[6] = (byte)(this._data_[6] & 0x1F);
        this._data_[6] = (byte)(this._data_[6] | flags << 5 & 0xE0);
    }

    public final int getFragmentOffset() {
        return (this._data_[6] & 0x1F) << 8 | this._data_[7] & 0xFF;
    }

    public void setFragmentOffset(int offset) {
        this._data_[6] = (byte)(this._data_[6] & 0xE0);
        this._data_[6] = (byte)(this._data_[6] | offset >> 8 & 0x1F);
        this._data_[7] = (byte)(offset & 0xFF);
    }

    public final int getProtocol() {
        return this._data_[9];
    }

    public final void setProtocol(int protocol) {
        this._data_[9] = (byte)protocol;
    }

    public final int getTTL() {
        return this._data_[8] & 0xFF;
    }

    public final void setTTL(int ttl) {
        this._data_[8] = (byte)(ttl & 0xFF);
    }

    protected int _computeChecksum_(int startOffset, int checksumOffset, int length, int virtualHeaderTotal, boolean update) {
        int total = 0;
        int i = startOffset;
        int imax = checksumOffset;
        while (i < imax) {
            total += (this._data_[i++] & 0xFF) << 8 | this._data_[i++] & 0xFF;
        }
        i = checksumOffset + 2;
        imax = length - length % 2;
        while (i < imax) {
            total += (this._data_[i++] & 0xFF) << 8 | this._data_[i++] & 0xFF;
        }
        if (i < length) {
            total += (this._data_[i] & 0xFF) << 8;
        }
        total += virtualHeaderTotal;
        while ((total & 0xFFFF0000) != 0) {
            total = (total & 0xFFFF) + (total >>> 16);
        }
        total = ~total & 0xFFFF;
        if (update) {
            this._data_[checksumOffset] = (byte)(total >> 8);
            this._data_[checksumOffset + 1] = (byte)(total & 0xFF);
        }
        return total;
    }

    public final int computeIPChecksum(boolean update) {
        return this._computeChecksum_(0, 10, this.getIPHeaderByteLength(), 0, update);
    }

    public final int computeIPChecksum() {
        return this.computeIPChecksum(true);
    }

    public final int getIPChecksum() {
        return (this._data_[10] & 0xFF) << 8 | this._data_[11] & 0xFF;
    }

    public final void getSource(byte[] address) {
        System.arraycopy(this._data_, 12, address, 0, address.length < 4 ? address.length : 4);
    }

    public final void getDestination(byte[] address) {
        System.arraycopy(this._data_, 16, address, 0, address.length < 4 ? address.length : 4);
    }

    public final void getSource(StringBuffer buffer) {
        OctetConverter.octetsToString(buffer, this._data_, 12);
    }

    public final void getDestination(StringBuffer buffer) {
        OctetConverter.octetsToString(buffer, this._data_, 16);
    }

    public final int getSourceAsWord() {
        return OctetConverter.octetsToInt(this._data_, 12);
    }

    public final void setSourceAsWord(int src) {
        OctetConverter.intToOctets(src, this._data_, 12);
    }

    public final int getDestinationAsWord() {
        return OctetConverter.octetsToInt(this._data_, 16);
    }

    public final void setDestinationAsWord(int dest) {
        OctetConverter.intToOctets(dest, this._data_, 16);
    }

    public final InetAddress getSourceAsInetAddress() throws UnknownHostException {
        StringBuffer buf = new StringBuffer();
        this.getSource(buf);
        return InetAddress.getByName(buf.toString());
    }

    public final InetAddress getDestinationAsInetAddress() throws UnknownHostException {
        StringBuffer buf = new StringBuffer();
        this.getDestination(buf);
        return InetAddress.getByName(buf.toString());
    }
}

